/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.testutils.DefaultServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;

class KerberosKDCUtil {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    static final int LDAP_PORT = 11389;
    static final int KDC_PORT = 6088;
    private static final String DIRECTORY_NAME = "Test Service";
    private static boolean initialised;
    private static Path workingDir;
    private static DirectoryService directoryService;
    private static LdapServer ldapServer;
    private static KdcServer kdcServer;

    KerberosKDCUtil() {
    }

    public static boolean startServer() throws Exception {
        if (initialised) {
            return false;
        }
        KerberosKDCUtil.setupEnvironment();
        KerberosKDCUtil.startLdapServer();
        KerberosKDCUtil.startKDC();
        initialised = true;
        return true;
    }

    private static void startLdapServer() throws Exception {
        KerberosKDCUtil.createWorkingDir();
        DefaultDirectoryServiceFactory dsf = new DefaultDirectoryServiceFactory();
        dsf.init(DIRECTORY_NAME);
        directoryService = dsf.getDirectoryService();
        directoryService.addLast((Interceptor)new KeyDerivationInterceptor());
        directoryService.getChangeLog().setEnabled(false);
        SchemaManager schemaManager = directoryService.getSchemaManager();
        KerberosKDCUtil.createPartition((DirectoryServiceFactory)dsf, schemaManager, "users", "ou=users,dc=undertow,dc=io");
        CoreSession adminSession = directoryService.getAdminSession();
        Map<String, String> mappings = Collections.singletonMap("hostname", DefaultServer.getDefaultServerAddress().getHostString());
        KerberosKDCUtil.processLdif(schemaManager, adminSession, "partition.ldif", mappings);
        KerberosKDCUtil.processLdif(schemaManager, adminSession, "krbtgt.ldif", mappings);
        KerberosKDCUtil.processLdif(schemaManager, adminSession, "user.ldif", mappings);
        KerberosKDCUtil.processLdif(schemaManager, adminSession, "server.ldif", mappings);
        ldapServer = new LdapServer();
        ldapServer.setServiceName("DefaultLDAP");
        TcpTransport ldap = new TcpTransport("0.0.0.0", 11389, 3, 5);
        ldapServer.addTransports(new Transport[]{ldap});
        ldapServer.setDirectoryService(directoryService);
        ldapServer.start();
    }

    private static void createPartition(DirectoryServiceFactory dsf, SchemaManager schemaManager, String id, String suffix) throws Exception {
        PartitionFactory pf = dsf.getPartitionFactory();
        Partition p = pf.createPartition(schemaManager, id, suffix, 1000, workingDir.toFile());
        pf.addIndex(p, "krb5PrincipalName", 10);
        p.initialize();
        directoryService.addPartition(p);
    }

    private static void processLdif(SchemaManager schemaManager, CoreSession adminSession, String ldifName, Map<String, String> mappings) throws Exception {
        int current;
        InputStream resourceInput = KerberosKDCUtil.class.getResourceAsStream("/ldif/" + ldifName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(resourceInput.available());
        while ((current = resourceInput.read()) != -1) {
            if (current == 36) {
                int second = resourceInput.read();
                if (second == 123) {
                    String toReplace;
                    ByteArrayOutputStream substitute = new ByteArrayOutputStream();
                    while ((current = resourceInput.read()) != -1 && current != 125) {
                        substitute.write(current);
                    }
                    if (current == -1) {
                        baos.write(current);
                        baos.write(second);
                        baos.write(substitute.toByteArray());
                    }
                    if (mappings.containsKey(toReplace = new String(substitute.toByteArray(), StandardCharsets.UTF_8))) {
                        baos.write(mappings.get(toReplace).getBytes());
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("No mapping found for '%s'", toReplace));
                }
                baos.write(current);
                baos.write(second);
                continue;
            }
            baos.write(current);
        }
        ByteArrayInputStream ldifInput = new ByteArrayInputStream(baos.toByteArray());
        LdifReader ldifReader = new LdifReader((InputStream)ldifInput);
        for (LdifEntry ldifEntry : ldifReader) {
            adminSession.add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        ldifReader.close();
        ldifInput.close();
    }

    private static void startKDC() throws Exception {
        kdcServer = new KdcServer();
        kdcServer.setServiceName("Test KDC");
        kdcServer.setSearchBaseDn("ou=users,dc=undertow,dc=io");
        KerberosConfig config = kdcServer.getConfig();
        config.setServicePrincipal("krbtgt/UNDERTOW.IO@UNDERTOW.IO");
        config.setPrimaryRealm("UNDERTOW.IO");
        config.setPaEncTimestampRequired(false);
        UdpTransport udp = new UdpTransport("0.0.0.0", 6088);
        kdcServer.addTransports(new Transport[]{udp});
        kdcServer.setDirectoryService(directoryService);
        kdcServer.start();
    }

    private static void setupEnvironment() {
        URL configPath = KerberosKDCUtil.class.getResource("/krb5.conf");
        System.setProperty("java.security.krb5.conf", configPath.getFile());
    }

    private static void createWorkingDir() throws IOException {
        if (workingDir == null && !Files.exists(workingDir = Paths.get(".", "target", "apacheds_working"), new LinkOption[0])) {
            Files.createDirectories(workingDir, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(workingDir);){
            for (Path child : stream) {
                Files.delete(child);
            }
        }
    }

    static Subject login(String userName, char[] password) throws LoginException {
        Subject theSubject = new Subject();
        UsernamePasswordCBH cbh = new UsernamePasswordCBH(userName, password);
        LoginContext lc = new LoginContext("KDC", theSubject, cbh, KerberosKDCUtil.createJaasConfiguration());
        lc.login();
        return theSubject;
    }

    private static Configuration createJaasConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException("Unexpected name '" + name + "'");
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("debug", "true");
                options.put("refreshKrb5Config", "true");
                if (IS_IBM) {
                    options.put("noAddress", "true");
                    options.put("credsType", "both");
                    entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                } else {
                    options.put("storeKey", "true");
                    options.put("isInitiator", "true");
                    entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                }
                return entries;
            }
        };
    }

    private static class UsernamePasswordCBH
    implements CallbackHandler {
        private final String username;
        private final char[] password;

        private UsernamePasswordCBH(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

