/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.proxy;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.FileUtils;
import io.undertow.util.HttpString;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class ProxyProtocolTestCase {
    private Undertow undertow = Undertow.builder().addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.HTTP).setHost(DefaultServer.getHostAddress()).setUseProxyProtocol(true).setPort(0)).setHandler(new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.setPersistent(false);
            exchange.getResponseHeaders().put(new HttpString("result"), exchange.getSourceAddress().toString() + " " + exchange.getDestinationAddress().toString());
        }
    }).build();
    private Undertow undertowSsl = Undertow.builder().addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.HTTPS).setSslContext(DefaultServer.getServerSslContext()).setHost(DefaultServer.getHostAddress()).setUseProxyProtocol(true).setPort(0)).setHandler(new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.setPersistent(false);
            exchange.getResponseHeaders().put(new HttpString("result"), exchange.getSourceAddress().toString() + " " + exchange.getDestinationAddress().toString());
        }
    }).build();

    @Test
    public void testProxyProtocolTcp4() throws Exception {
        String request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 0 65535\r\nGET / HTTP/1.0\r\n\r\n";
        expectedResponse = "result: /1.2.3.4:0 /5.6.7.8:65535";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
    }

    @Test
    public void testProxyProtocolTcp4Negative() throws Exception {
        String request = "PROXY  TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4  1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4  5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8  444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444  555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\rGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 001.002.003.004 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 111444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 111555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 -444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 -555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 0444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 0555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 277.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5d.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY, TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    @Test
    public void testProxyProtocolTcp6() throws Exception {
        String request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:444 /fe80:0:0:0:5ec5:d4ff:fede:66d8:555";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 0 65535\r\nGET / HTTP/1.0\r\n\r\n";
        expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:0 /fe80:0:0:0:5ec5:d4ff:fede:66d8:65535";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
    }

    @Test
    public void testProxyProtocolTcp6Negative() throws Exception {
        String request = "PROXY  TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6  fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc  fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8  444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444  555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\rGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fz80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5zc5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 111444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 111555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 -444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 -555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 0444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 0555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY, TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    @Test
    public void testProxyProtocolNegative() throws Exception {
        String request = "NONSENSE\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "NONSENSE TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "NONSENSE\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY NONSENSE\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY NONSENSE 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyProtocolRequestResponseCheck(String request, String expectedResponse) throws Exception {
        try {
            this.undertow.start();
            int port = ((InetSocketAddress)((Undertow.ListenerInfo)this.undertow.getListenerInfo().get(0)).getAddress()).getPort();
            Socket s = new Socket(DefaultServer.getHostAddress(), port);
            s.getOutputStream().write(request.getBytes(StandardCharsets.US_ASCII));
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expectedResponse));
        }
        finally {
            this.undertow.stop();
        }
    }

    @Test
    public void testProxyProtocolSSl() throws Exception {
        String request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\r\n";
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, expectedResponse);
        request = "PROXY TCP4  1.2.3.4 5.6.7.8 444 555\r\n";
        requestHttp = "GET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyProtocolRequestResponseCheck(String requestProxy, String requestHttp, String expectedResponse) throws Exception {
        try {
            this.undertowSsl.start();
            int port = ((InetSocketAddress)((Undertow.ListenerInfo)this.undertowSsl.getListenerInfo().get(0)).getAddress()).getPort();
            Socket s = new Socket(DefaultServer.getHostAddress(), port);
            s.getOutputStream().write(requestProxy.getBytes(StandardCharsets.US_ASCII));
            if (!expectedResponse.isEmpty()) {
                s = DefaultServer.getClientSSLContext().getSocketFactory().createSocket(s, DefaultServer.getHostAddress(), port, true);
                s.getOutputStream().write(requestHttp.getBytes(StandardCharsets.US_ASCII));
            }
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expectedResponse));
        }
        finally {
            this.undertowSsl.stop();
        }
    }

    @Test
    public void testProxyProtocolUnknownEmpty() throws Exception {
        this.doTestProxyProtocolUnknown("");
    }

    @Test
    public void testProxyProtocolUnknownSpace() throws Exception {
        this.doTestProxyProtocolUnknown(" ");
    }

    @Test
    public void testProxyProtocolUnknownJunk() throws Exception {
        this.doTestProxyProtocolUnknown(" mekmitasdigoat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestProxyProtocolUnknown(String extra) throws Exception {
        try {
            this.undertow.start();
            InetSocketAddress serverAddress = (InetSocketAddress)((Undertow.ListenerInfo)this.undertow.getListenerInfo().get(0)).getAddress();
            Socket s = new Socket(serverAddress.getAddress(), serverAddress.getPort());
            String expected = String.format("result: /%s:%d /%s:%d", s.getLocalAddress().getHostAddress(), s.getLocalPort(), serverAddress.getAddress().getHostAddress(), serverAddress.getPort());
            s.getOutputStream().write(("PROXY UNKNOWN" + extra + "\r\nGET / HTTP/1.0\r\n\r\n").getBytes(StandardCharsets.US_ASCII));
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expected));
        }
        finally {
            this.undertow.stop();
        }
    }
}

