/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AjpRequestParseState;
import io.undertow.server.protocol.ajp.AjpRequestParser;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.BadRequestException;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xnio.IoUtils;

@Category(value={UnitTest.class})
public class AjpParsingUnitTestCase {
    private static final ByteBuffer buffer;
    public static final AjpRequestParser AJP_REQUEST_PARSER;

    @Test
    public void testAjpParsing() throws IOException, BadRequestException {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        AJP_REQUEST_PARSER.parse(buffer, state, result);
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        this.testResult(result);
    }

    @Test
    public void testByteByByteAjpParsing() throws IOException, BadRequestException {
        ByteBuffer buffer = AjpParsingUnitTestCase.buffer.duplicate();
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        int limit = buffer.limit();
        for (int i = 1; i <= limit; ++i) {
            buffer.limit(i);
            AJP_REQUEST_PARSER.parse(buffer, state, result);
        }
        Assert.assertEquals((long)165L, (long)state.dataSize);
        Assert.assertTrue((boolean)state.isComplete());
        this.testResult(result);
    }

    private void testResult(HttpServerExchange exchange) {
        Assert.assertSame((Object)Methods.GET, (Object)exchange.getRequestMethod());
        Assert.assertEquals((Object)Protocols.HTTP_1_1, (Object)exchange.getProtocol());
        Assert.assertEquals((long)3L, (long)exchange.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"localhost:7777", (Object)exchange.getRequestHeaders().getFirst(Headers.HOST));
        Assert.assertEquals((Object)"Apache-HttpClient/4.1.3 (java 1.5)", (Object)exchange.getRequestHeaders().getFirst(Headers.USER_AGENT));
        Assert.assertEquals((Object)"Keep-Alive", (Object)exchange.getRequestHeaders().getFirst(Headers.CONNECTION));
    }

    @Test
    public void testCharsetHandling() throws Exception {
        ByteBuffer data = this.createAjpRequest("/hi".getBytes(StandardCharsets.UTF_8), "param=value".getBytes(StandardCharsets.UTF_8));
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        AJP_REQUEST_PARSER.parse(data, state, result);
        Assert.assertFalse((boolean)state.badRequest);
        Assert.assertEquals((Object)"/hi", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/hi", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"param=value", (Object)result.getQueryString());
        data = this.createAjpRequest("/\ud55c\uae00\uc774\ub984".getBytes(StandardCharsets.UTF_8), "param=\ud55c\uae00\uc774\ub984".getBytes(StandardCharsets.UTF_8));
        result = new HttpServerExchange(null);
        state = new AjpRequestParseState();
        AJP_REQUEST_PARSER.parse(data, state, result);
        Assert.assertFalse((boolean)state.badRequest);
        Assert.assertEquals((Object)"/\ud55c\uae00\uc774\ub984", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/\ud55c\uae00\uc774\ub984", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"param=\ud55c\uae00\uc774\ub984", (Object)result.getQueryString());
    }

    @Test
    public void testInvalidQueryString() throws Exception {
        ByteBuffer data = this.createAjpRequest("/hi".getBytes(StandardCharsets.UTF_8), "param=value%http".getBytes(StandardCharsets.UTF_8));
        HttpServerExchange result = new HttpServerExchange(null);
        AjpRequestParseState state = new AjpRequestParseState();
        AJP_REQUEST_PARSER.parse(data, state, result);
        Assert.assertTrue((boolean)state.badRequest);
    }

    protected ByteBuffer createAjpRequest(byte[] path, byte[] query) {
        ByteBuffer data = ByteBuffer.allocate(1000);
        data.put((byte)18);
        data.put((byte)52);
        data.put((byte)0);
        data.put((byte)0);
        data.put((byte)2);
        data.put((byte)2);
        AjpParsingUnitTestCase.putString(data, "HTTP/1.1");
        AjpParsingUnitTestCase.putString(data, path);
        AjpParsingUnitTestCase.putString(data, "");
        AjpParsingUnitTestCase.putString(data, "");
        AjpParsingUnitTestCase.putString(data, "");
        AjpParsingUnitTestCase.putInt(data, 100);
        data.put((byte)0);
        AjpParsingUnitTestCase.putInt(data, 0);
        AjpParsingUnitTestCase.putQueryAttribute(data, query);
        data.put((byte)-1);
        int dataLength = data.position() - 4;
        data.put(2, (byte)(dataLength >> 8 & 0xFF));
        data.put(3, (byte)(dataLength & 0xFF));
        data.flip();
        return data;
    }

    static void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    static void putString(ByteBuffer buf, String value) {
        int length = value.length();
        AjpParsingUnitTestCase.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    static void putString(ByteBuffer buf, byte[] value) {
        int length = value.length;
        AjpParsingUnitTestCase.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put(value[i]);
        }
        buf.put((byte)0);
    }

    static void putQueryAttribute(ByteBuffer buf, byte[] value) {
        int length = value.length;
        AjpParsingUnitTestCase.putInt(buf, 5);
        AjpParsingUnitTestCase.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put(value[i]);
        }
        buf.put((byte)0);
    }

    static {
        InputStream stream = AjpParsingUnitTestCase.class.getResourceAsStream("sample-ajp-request");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int r = 0;
            byte[] buf = new byte[1024];
            while ((r = stream.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            buffer = ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
        AJP_REQUEST_PARSER = new AjpRequestParser("UTF-8", true, 100, 100, false, true);
    }
}

