/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class InvalidHtpRequestTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)ResponseCodeHandler.HANDLE_200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCharacterInMethod() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpRequestBase method = new HttpRequestBase(){

                public String getMethod() {
                    return "GET;POST";
                }

                public URI getURI() {
                    try {
                        return new URI(DefaultServer.getDefaultServerURL());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            HttpResponse result = client.execute((HttpUriRequest)method);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCharacterInHeader() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet method = new HttpGet(DefaultServer.getDefaultServerURL());
            method.addHeader("fake;header", "value");
            HttpResponse result = client.execute((HttpUriRequest)method);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleContentLengths() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet method = new HttpGet(DefaultServer.getDefaultServerURL());
            method.addHeader("Content-Length", "0");
            method.addHeader("Content-Length", "10");
            HttpResponse result = client.execute((HttpUriRequest)method);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentLengthAndTransferEncoding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet method = new HttpGet(DefaultServer.getDefaultServerURL());
            method.addHeader("Content-Length", "0");
            method.addHeader("Transfer-Encoding", "chunked");
            HttpResponse result = client.execute((HttpUriRequest)method);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleTransferEncoding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet method = new HttpGet(DefaultServer.getDefaultServerURL());
            method.addHeader("Transfer-Encoding", "chunked");
            method.addHeader("Transfer-Encoding", "gzip, chunked");
            HttpResponse result = client.execute((HttpUriRequest)method);
            Assert.assertEquals((long)400L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

