/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.Version;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.accesslog.ExtendedAccessLogParser;
import io.undertow.server.handlers.accesslog.LogFileHeaderGenerator;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import io.undertow.util.FileUtils;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ExtendedAccessLogFileTestCase {
    private static final Path logDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "logs");
    public static final String PATTERN = "cs-uri cs(test-header) x-O(aa) x-H(secure)";
    private static final HttpHandler HELLO_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseHeaders().put(new HttpString("aa"), "bb");
            exchange.getResponseSender().send("Hello");
        }
    };

    @Before
    public void before() throws IOException {
        Files.createDirectories(logDirectory, new FileAttribute[0]);
        DefaultServer.startSSLServer();
    }

    @After
    public void after() throws IOException {
        DefaultServer.stopSSLServer();
        FileUtils.deleteRecursive((Path)logDirectory);
    }

    @Test
    public void testSingleLogMessageToFile() throws IOException, InterruptedException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("extended.log");
        DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)DefaultServer.getWorker()).setOutputDirectory(directory).setLogBaseName("extended.").setLogFileHeaderGenerator((LogFileHeaderGenerator)new ExtendedAccessLogParser.ExtendedAccessLogHeaderGenerator(PATTERN)).build();
        this.verifySingleLogMessageToFile(logFileName, logReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySingleLogMessageToFile(Path logFileName, DefaultAccessLogReceiver logReceiver) throws IOException, InterruptedException {
        CompletionLatchHandler latchHandler = new CompletionLatchHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, PATTERN, new ExtendedAccessLogParser(ExtendedAccessLogFileTestCase.class.getClassLoader()).parse(PATTERN)));
        DefaultServer.setRootHandler(latchHandler);
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress() + "/path");
            get.addHeader("test-header", "single-val");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            latchHandler.await();
            logReceiver.awaitWrittenForTest();
            String data = new String(Files.readAllBytes(logFileName));
            String[] lines = data.split("\n");
            Assert.assertEquals((Object)"#Fields: cs-uri cs(test-header) x-O(aa) x-H(secure)", (Object)lines[0]);
            Assert.assertEquals((Object)"#Version: 2.0", (Object)lines[1]);
            Assert.assertEquals((Object)("#Software: " + Version.getFullVersionString()), (Object)lines[2]);
            Assert.assertEquals((Object)"", (Object)lines[3]);
            Assert.assertEquals((Object)"/path 'single-val' 'bb' true", (Object)lines[4]);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

