/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.ETag;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class PathResourceManagerTestCase {
    @Test
    public void testGetResource() throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        PathResourceManager resourceManager = new PathResourceManager(rootPath, 0x100000L);
        Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
        Assert.assertNotNull((Object)resourceManager.getResource("./page.html"));
        Assert.assertNotNull((Object)resourceManager.getResource("../file/page.html"));
    }

    @Test
    public void testListDir() throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        PathResourceManager resourceManager = new PathResourceManager(rootPath, 0x100000L);
        Resource subdir = resourceManager.getResource("subdir");
        Resource found = (Resource)subdir.list().get(0);
        Assert.assertEquals((Object)("subdir" + File.separatorChar + "a.txt"), (Object)found.getPath());
    }

    @Test
    public void testCantEscapeRoot() throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent().resolve("subdir");
        PathResourceManager resourceManager = new PathResourceManager(rootPath, 0x100000L);
        Assert.assertNotNull((Object)resourceManager.getResource("a.txt"));
        Assert.assertNull((Object)resourceManager.getResource("../page.html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseDirInSymlink() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        Path filePath = Paths.get(this.getClass().getResource("page.html").toURI());
        Path rootPath = filePath.getParent();
        Path newDir = rootPath.resolve("newDir");
        Path innerPage = newDir.resolve("page.html");
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            Files.createDirectories(newDir, new FileAttribute[0]);
            Files.copy(filePath, innerPage, new CopyOption[0]);
            Files.createSymbolicLink(newSymlink, newDir, new FileAttribute[0]);
            Assert.assertTrue((String)"Ensure that newSymlink is still a symlink as expected", (boolean)Files.isSymbolicLink(newSymlink));
            PathResourceManager resourceManager = new PathResourceManager(newSymlink, 0x100000L);
            Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
            Assert.assertNull((Object)resourceManager.getResource("Page.html"));
            Assert.assertNotNull((Object)resourceManager.getResource("./page.html"));
        }
        finally {
            Files.deleteIfExists(newSymlink);
            Files.deleteIfExists(innerPage);
            Files.deleteIfExists(newDir);
            Files.deleteIfExists(newDir);
        }
    }

    @Test
    public void testETagFunction() throws Exception {
        String fileName = "page.html";
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        ResourceManager resourceManager = PathResourceManager.builder().setBase(rootPath).setETagFunction(new PathResourceManager.ETagFunction(){

            public ETag generate(Path path) {
                return new ETag(true, path.getFileName().toString());
            }
        }).build();
        ETag expected = new ETag(true, "page.html");
        ETag actual = resourceManager.getResource("page.html").getETag();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonDefaultFileSystem() throws Exception {
        Path zipFile = Files.createTempFile("undertow", ".zip", new FileAttribute[0]);
        try {
            String expectedText = "Hello, world!";
            byte[] expectedBytes = expectedText.getBytes(StandardCharsets.UTF_8);
            try (OutputStream os = Files.newOutputStream(zipFile, new OpenOption[0]);
                 BufferedOutputStream bos = new BufferedOutputStream(os);
                 ZipOutputStream zos = new ZipOutputStream(bos);){
                zos.putNextEntry(new ZipEntry("dir/"));
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("dir/resource.txt"));
                zos.write(expectedBytes);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("root_resource.txt"));
                zos.write(expectedBytes);
                zos.closeEntry();
            }
            var5_5 = null;
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipFile, null);){
                PathResourceManager resourceManager = new PathResourceManager(zipFileSystem.getPath("/dir", new String[0]));
                Resource resource = resourceManager.getResource("resource.txt");
                Assert.assertArrayEquals((byte[])expectedBytes, (byte[])Files.readAllBytes(resource.getFilePath()));
                try {
                    resourceManager.registerResourceChangeListener(changes -> {});
                    Assert.fail((String)"registerResourceChangeListener should have failed");
                }
                catch (IllegalStateException zos) {
                    // empty catch block
                }
                try {
                    resource.getFile();
                    Assert.fail((String)"getFile should have failed");
                }
                catch (UnsupportedOperationException zos) {
                    // empty catch block
                }
                Resource dir = resourceManager.getResource(".");
                Assert.assertTrue((boolean)dir.isDirectory());
                List list = dir.list();
                Assert.assertEquals((long)1L, (long)list.size());
                Assert.assertEquals((Object)resource.getFilePath(), (Object)((Resource)list.get(0)).getFilePath());
                Resource outside = resourceManager.getResource("../root_resource.txt");
                Assert.assertNull((Object)outside);
                Resource doesNotExist = resourceManager.getResource("does_not_exist.txt");
                Assert.assertNull((Object)doesNotExist);
                resourceManager.setBase(Paths.get(this.getClass().getResource("page.html").toURI()).getParent());
                Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
                resourceManager.setBase(zipFileSystem.getPath("/", new String[0]));
                Assert.assertNotNull((Object)resourceManager.getResource("root_resource.txt"));
                resourceManager.setBase(new File(this.getClass().getResource("page.html").toURI()).getParentFile());
                Assert.assertNotNull((Object)resourceManager.getResource("page.html"));
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        finally {
            Files.deleteIfExists(zipFile);
        }
    }
}

