/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.JDBCLogHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class JDBCLogDatabaseTestCase {
    private static final int NUM_THREADS = 10;
    private static final int NUM_REQUESTS = 12;
    private static final HttpHandler HELLO_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send("Hello");
        }
    };
    private JdbcConnectionPool ds;

    @Before
    public void setup() throws SQLException {
        this.ds = JdbcConnectionPool.create((String)"jdbc:h2:mem:test;DB_CLOSE_DELAY=-1", (String)"user", (String)"password");
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.ds.getConnection();
            conn.setAutoCommit(true);
            statement = conn.createStatement();
            statement.executeUpdate("CREATE TABLE PUBLIC.ACCESS ( id SERIAL NOT NULL, remoteHost CHAR(15) NOT NULL, userName CHAR(15), timestamp TIMESTAMP NOT NULL, virtualHost VARCHAR(64), method VARCHAR(8), query VARCHAR(255) NOT NULL, status SMALLINT UNSIGNED NOT NULL, bytes INT UNSIGNED NOT NULL, referer VARCHAR(128), userAgent VARCHAR(128), PRIMARY KEY (id) );");
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    @After
    public void teardown() throws SQLException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.ds.getConnection();
            conn.setAutoCommit(true);
            statement = conn.createStatement();
            statement.executeUpdate("DROP TABLE PUBLIC.ACCESS;");
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        this.ds.dispose();
        this.ds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleLogMessageToDatabase() throws IOException, InterruptedException, SQLException {
        JDBCLogHandler logHandler = new JDBCLogHandler(HELLO_HANDLER, (Executor)DefaultServer.getWorker(), "common", (DataSource)this.ds);
        CompletionLatchHandler latchHandler = new CompletionLatchHandler((HttpHandler)logHandler);
        DefaultServer.setRootHandler(latchHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            latchHandler.await();
            logHandler.awaitWrittenForTest();
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            Connection conn = null;
            Statement statement = null;
            try {
                conn = this.ds.getConnection();
                statement = conn.createStatement();
                ResultSet resultDatabase = statement.executeQuery("SELECT * FROM PUBLIC.ACCESS;");
                resultDatabase.next();
                Assert.assertEquals((Object)DefaultServer.getDefaultServerAddress().getAddress().getHostAddress(), (Object)resultDatabase.getString(logHandler.getRemoteHostField()));
                Assert.assertEquals((Object)"5", (Object)resultDatabase.getString(logHandler.getBytesField()));
                Assert.assertEquals((Object)"200", (Object)resultDatabase.getString(logHandler.getStatusField()));
                client.getConnectionManager().shutdown();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogLotsOfThreadsToDatabase() throws IOException, InterruptedException, ExecutionException, SQLException {
        JDBCLogHandler logHandler = new JDBCLogHandler(HELLO_HANDLER, (Executor)DefaultServer.getWorker(), "combined", (DataSource)this.ds);
        CompletionLatchHandler latchHandler = new CompletionLatchHandler(120, (HttpHandler)logHandler);
        DefaultServer.setRootHandler(latchHandler);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList futures = new ArrayList();
            int i = 0;
            while (i < 10) {
                int n = i++;
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            for (int i = 0; i < 12; ++i) {
                                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
                                HttpResponse result = client.execute((HttpUriRequest)get);
                                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                                String response = HttpClientUtils.readResponse(result);
                                Assert.assertEquals((Object)"Hello", (Object)response);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
        latchHandler.await();
        logHandler.awaitWrittenForTest();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.ds.getConnection();
            statement = conn.createStatement();
            ResultSet resultSet = conn.createStatement().executeQuery("SELECT COUNT(*) FROM PUBLIC.ACCESS;");
            resultSet.next();
            Assert.assertEquals((long)resultSet.getInt(1), (long)120L);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

