/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Deque;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class AjpCharacterEncodingTestCase {
    private static final int PORT = DefaultServer.getHostPort() + 10;
    private static Undertow undertow;
    private static OptionMap old;

    @BeforeClass
    public static void setup() throws Exception {
        undertow = Undertow.builder().setServerOption(UndertowOptions.URL_CHARSET, (Object)"MS949").addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.AJP).setHost(DefaultServer.getHostAddress()).setPort(PORT)).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("RESULT:" + (String)((Deque)exchange.getQueryParameters().get("p")).getFirst());
            }
        }).build();
        undertow.start();
        DefaultServer.setRootHandler((HttpHandler)ProxyHandler.builder().setProxyClient((ProxyClient)new LoadBalancingProxyClient().addHost(new URI("ajp://" + DefaultServer.getHostAddress() + ":" + PORT))).build());
        old = DefaultServer.getUndertowOptions();
        DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true, (Option)UndertowOptions.URL_CHARSET, (Object)"MS949"));
    }

    @AfterClass
    public static void after() {
        DefaultServer.setUndertowOptions(old);
        undertow.stop();
    }

    @Test
    public void sendHttpRequest() throws IOException {
        Socket socket = new Socket(DefaultServer.getHostAddress(), DefaultServer.getHostPort());
        socket.getOutputStream().write("GET /path?p=\ud55c%20\uae00 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n".getBytes("MS949"));
        String result = FileUtils.readFile((InputStream)socket.getInputStream());
        Assert.assertTrue((String)("Failed to find expected result \n" + result), (boolean)result.contains("\ud55c \uae00"));
    }
}

