/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.FlexBase64;
import io.undertow.util.SubstringMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class SubstringMapTestCase {
    public static final int NUM_TEST_VALUES = 1000;

    @Test
    public void testSubstringMap() {
        SubstringMap paths = new SubstringMap();
        for (int count = 0; count < 10; ++count) {
            Object p;
            int i;
            int seed = new Random().nextInt();
            Random random = new Random(seed);
            System.out.println("Using Seed " + seed);
            ArrayList<String> parts = new ArrayList<String>();
            HashSet<String> keys = new HashSet<String>();
            for (i = 0; i < 1000; ++i) {
                byte[] bytes;
                String s = null;
                do {
                    bytes = new byte[random.nextInt(30) + 5];
                    random.nextBytes(bytes);
                } while (keys.contains(s = FlexBase64.encodeString((byte[])bytes, (boolean)false)));
                keys.add(s);
                parts.add(s);
                paths.put(s, (Object)i);
                Assert.assertEquals((Object)i, (Object)paths.get(s, s.length()).getValue());
                Assert.assertEquals((Object)i, (Object)paths.get(s + "fooosdf", s.length()).getValue());
                String missing = s + "asdfdasfasf";
                Assert.assertNull((Object)paths.get(missing, missing.length()));
            }
            for (String k : paths.keys()) {
                Assert.assertTrue((boolean)keys.remove(k));
            }
            Assert.assertEquals((long)0L, (long)keys.size());
            for (i = 0; i < 1000; ++i) {
                p = (String)parts.get(i);
                Assert.assertEquals((Object)i, (Object)paths.get((String)p, ((String)p).length()).getValue());
                Assert.assertEquals((Object)i, (Object)paths.get((String)p + "asdfdsafasfw", ((String)p).length()).getValue());
            }
            for (i = 0; i < 1000; ++i) {
                p = (Integer)paths.remove((String)parts.get(i));
                Assert.assertEquals((Object)i, (Object)p);
            }
        }
    }
}

