/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.encoding.ContentEncodedResourceManager;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ContentEncodedResourceTestCase {
    public static final String DIR_NAME = "contentEncodingTestCase";
    static Path tmpDir;

    @BeforeClass
    public static void setup() throws IOException {
        tmpDir = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), DIR_NAME, new FileAttribute[0]);
        PathResourceManager resourceManager = new PathResourceManager(tmpDir, 0xA00000L);
        DefaultServer.setRootHandler((HttpHandler)new ResourceHandler((ResourceManager)resourceManager).setContentEncodedResourceManager(new ContentEncodedResourceManager(tmpDir, new CachingResourceManager(100, 10000L, null, (ResourceManager)resourceManager, -1), new ContentEncodingRepository().addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50, null), 0, 100000, null)));
    }

    @AfterClass
    public static void after() throws IOException {
        FileUtils.deleteRecursive((Path)tmpDir);
    }

    @Test
    public void testFileIsCompressed() throws IOException, InterruptedException {
        String fileName = "hello.html";
        Path f = tmpDir.resolve(fileName);
        Files.write(f, "hello world".getBytes(), new OpenOption[0]);
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            for (int i = 0; i < 3; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + fileName);
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                String response = HttpClientUtils.readResponse((HttpResponse)result);
                Assert.assertEquals((Object)"hello world", (Object)response);
                assert (result.getEntity() instanceof DecompressingEntity);
                result.close();
            }
            Files.write(f, "modified file".getBytes(), new OpenOption[0]);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + fileName);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"hello world", (Object)response);
            assert (result.getEntity() instanceof DecompressingEntity);
        }
    }
}

