/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;

public class NetworkUtilsAddressObfuscationTestCase {
    private static String cvt(String input) throws UnknownHostException {
        return NetworkUtils.toObfuscatedString((InetAddress)InetAddress.getByName(input));
    }

    @Test
    public void testIpV4Address() throws IOException {
        Assert.assertEquals((Object)"1.123.255.", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("1.123.255.2"));
        Assert.assertEquals((Object)"127.0.0.", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("127.0.0.1"));
        Assert.assertEquals((Object)"0.0.0.", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("0.0.0.0"));
    }

    @Test
    public void testIpv6Address() throws IOException {
        Assert.assertEquals((Object)"2001:1db8:", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("2001:1db8:100:3:6:ff00:42:8329"));
        Assert.assertEquals((Object)"2001:1db8:", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("2001:1db8:100::6:ff00:42:8329"));
        Assert.assertEquals((Object)"0:0:", (Object)NetworkUtilsAddressObfuscationTestCase.cvt("::1"));
    }
}

