/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class ReadTimeoutTestCase {
    private volatile Exception exception;

    @DefaultServer.BeforeServerStarts
    public static void beforeClass() {
        DefaultServer.setServerOptions(OptionMap.create((Option)Options.READ_TIMEOUT, (Object)10));
    }

    @DefaultServer.AfterServerStops
    public static void afterClass() {
        DefaultServer.setServerOptions(OptionMap.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeout() throws InterruptedException, IOException {
        CountDownLatch errorLatch = new CountDownLatch(1);
        DefaultServer.setRootHandler(exchange -> {
            StreamSinkChannel response = exchange.getResponseChannel();
            StreamSourceChannel request = exchange.getRequestChannel();
            request.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, channel -> new StringWriteChannelListener("COMPLETED"){

                protected void writeDone(StreamSinkChannel channel) {
                    exchange.endExchange();
                }
            }.setup(response), (channel, e) -> {
                e.printStackTrace();
                exchange.endExchange();
                this.exception = e;
                errorLatch.countDown();
            }));
            request.wakeupReads();
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new AbstractHttpEntity(){

                public InputStream getContent() throws IllegalStateException {
                    return null;
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    for (int i = 0; i < 5; ++i) {
                        outstream.write(42);
                        outstream.flush();
                        try {
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return 5L;
                }
            });
            post.addHeader("Connection", "close");
            boolean socketFailure = false;
            try {
                client.execute((HttpUriRequest)post);
            }
            catch (SocketException e) {
                Assert.assertTrue((String)e.getMessage(), (e.getMessage().contains("Broken pipe") || e.getMessage().contains("connection abort") ? 1 : 0) != 0);
                socketFailure = true;
            }
            Assert.assertTrue((String)"Test sent request without any exception", (boolean)socketFailure);
            if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                Assert.assertTrue((String)this.getExceptionDescription(this.exception), (this.exception instanceof ReadTimeoutException || DefaultServer.isProxy() && this.exception instanceof IOException ? 1 : 0) != 0);
                if (this.exception.getSuppressed() != null && this.exception.getSuppressed().length > 0) {
                    for (Throwable supressed : this.exception.getSuppressed()) {
                        Assert.assertEquals((String)this.getExceptionDescription(supressed), ReadTimeoutException.class, this.exception.getClass());
                    }
                }
            } else if (!DefaultServer.isProxy()) {
                Assert.fail((String)"Did not get ReadTimeoutException");
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    private String getExceptionDescription(Throwable exception) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

