/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.blocking;

import io.undertow.io.UndertowOutputStream;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class BlockingServerStreamResetTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseAfterStreamReset() throws IOException {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                UndertowOutputStream stream = (UndertowOutputStream)exchange.getOutputStream();
                stream.write(1);
                Assert.assertEquals((long)1L, (long)stream.getBytesWritten());
                stream.resetBuffer();
                Assert.assertEquals((long)0L, (long)stream.getBytesWritten());
                exchange.getOutputStream().write("Hello, World".getBytes());
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello, World", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

