/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.handlers.Cookie;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.Cookies;
import io.undertow.util.Rfc6265CookieSupport;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class CookiesTestCase {
    @Test
    public void testParsingSetCookieHeaderV0() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_E_COYOTE; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertEquals((Object)CookiesTestCase.date(1999, 11, 9, 23, 12, 40), (Object)cookie.getExpires());
        cookie = Cookies.parseSetCookieHeader((String)"SHIPPING=FEDEX; path=/foo; secure");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/foo", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.isSecure());
        cookie = Cookies.parseSetCookieHeader((String)"SHIPPING=FEDEX");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testParsingSetCookieHeaderV1() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"Customer=\"WILE_E_COYOTE\"; Version=\"1\"; Path=\"/acme\"");
        Assert.assertEquals((Object)"Customer", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/acme", (Object)cookie.getPath());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        cookie = Cookies.parseSetCookieHeader((String)"SHIPPING=\"FEDEX\"; path=\"/foo\"; secure; Version=\"1\";");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/foo", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.isSecure());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
    }

    private static Date date(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(year, month - 1, day, hour, minute, second);
        return c.getTime();
    }

    @Test
    public void testInvalidCookie() {
        Map cookies = Cookies.parseRequestCookies((int)1, (boolean)false, Arrays.asList("\"; CUSTOMER=WILE_E_COYOTE"));
        Assert.assertFalse((boolean)cookies.containsKey("$Domain"));
        Assert.assertFalse((boolean)cookies.containsKey("$Version"));
        Assert.assertFalse((boolean)cookies.containsKey("$Path"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)1, (boolean)false, Arrays.asList("; CUSTOMER=WILE_E_COYOTE"));
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)1, (boolean)false, Arrays.asList("foobar; CUSTOMER=WILE_E_COYOTE"));
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
    }

    @Test
    public void testRequestCookieDomainPathVersion() {
        Map cookies = Cookies.parseRequestCookies((int)1, (boolean)false, Arrays.asList("CUSTOMER=WILE_E_COYOTE; $Domain=LOONEY_TUNES; $Version=1; $Path=/"));
        Assert.assertFalse((boolean)cookies.containsKey("$Domain"));
        Assert.assertFalse((boolean)cookies.containsKey("$Version"));
        Assert.assertFalse((boolean)cookies.containsKey("$Path"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testMultipleRequestCookies() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E_COYOTE; $Domain=LOONEY_TUNES; $Version=1; $Path=/; SHIPPING=FEDEX"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testEqualsInValueNotAllowed() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E_COYOTE=THE_COYOTE; SHIPPING=FEDEX"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testEmptyCookieNames() {
        Map cookies = Cookies.parseRequestCookies((int)4, (boolean)false, Arrays.asList("=foo; CUSTOMER=WILE_E_COYOTE=THE_COYOTE; =foobar; SHIPPING=FEDEX; =bar"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"foo", (Object)cookie.getValue());
    }

    @Test
    public void testEqualsInValueAllowed() {
        Map cookies = Cookies.parseRequestCookies((int)1, (boolean)true, Arrays.asList("CUSTOMER=WILE_E_COYOTE=THE_COYOTE"));
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE=THE_COYOTE", (Object)cookie.getValue());
    }

    @Test
    public void testEqualsInValueAllowedInQuotedValue() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)true, Arrays.asList("CUSTOMER=\"WILE_E_COYOTE=THE_COYOTE\"; SHIPPING=FEDEX"));
        Assert.assertEquals((long)2L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE=THE_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testEqualsInValueNotAllowedInQuotedValue() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=\"WILE_E_COYOTE=THE_COYOTE\"; SHIPPING=FEDEX"));
        Assert.assertEquals((long)2L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE=THE_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testCommaSeparatedCookies() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=\"WILE_E_COYOTE\", SHIPPING=FEDEX"), (boolean)true);
        Assert.assertEquals((long)2L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=\"WILE_E_COYOTE\"; SHIPPING=FEDEX"), (boolean)true);
        Assert.assertEquals((long)2L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testHttpSeparaterInV0CookieValue() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E COYOTE; SHIPPING=FEDEX"), (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E COYOTE; SHIPPING=FEDEX"), (boolean)true, (boolean)true);
        Assert.assertEquals((long)2L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E_COYOTE\"; SHIPPING=FEDEX"), (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER=WILE_E_COYOTE\"; SHIPPING=FEDEX"), (boolean)true, (boolean)true);
        Assert.assertEquals((long)2L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE\"", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
    }

    @Test
    public void testCookieContainsColonInJvmRoute() {
        Map cookies = Cookies.parseRequestCookies((int)3, (boolean)false, Arrays.asList("JSESSIONID=WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1; CUSTOMER=WILE_E COYOTE; SHIPPING=FEDEX"), (boolean)true, (boolean)false);
        Assert.assertEquals((long)3L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("JSESSIONID");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)3, (boolean)false, Arrays.asList("JSESSIONID=WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1; CUSTOMER=WILE_E COYOTE; SHIPPING=FEDEX"), (boolean)true, (boolean)true);
        Assert.assertEquals((long)3L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("JSESSIONID");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)3, (boolean)false, Arrays.asList("JSESSIONID=WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1; CUSTOMER=WILE_E_COYOTE\"; SHIPPING=FEDEX"), (boolean)true, (boolean)false);
        Assert.assertEquals((long)3L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("JSESSIONID");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1", (Object)cookie.getValue());
        cookies = Cookies.parseRequestCookies((int)3, (boolean)false, Arrays.asList("JSESSIONID=WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1; CUSTOMER=WILE_E_COYOTE\"; SHIPPING=FEDEX"), (boolean)true, (boolean)true);
        Assert.assertEquals((long)3L, (long)cookies.size());
        cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WILE_E_COYOTE\"", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("JSESSIONID");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"WCGWBPJ8DUmv0fvREqVQZb8E6bzW92iHnzysV_q_.master:node1", (Object)cookie.getValue());
    }

    @Test
    public void testQuotedEscapedStringInRequestCookie() {
        Map cookies = Cookies.parseRequestCookies((int)3, (boolean)false, Arrays.asList("Customer=\"WILE_\\\"E_\\\"COYOTE\"; $Version=\"1\"; $Path=\"/acme\"; SHIPPING=\"FEDEX\\\\\"; foo=\"\\\""));
        Cookie cookie = (Cookie)cookies.get("Customer");
        Assert.assertEquals((Object)"Customer", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_\"E_\"COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/acme", (Object)cookie.getPath());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX\\\\", (Object)cookie.getValue());
        cookie = (Cookie)cookies.get("foo");
        Assert.assertEquals((Object)"foo", (Object)cookie.getName());
        Assert.assertEquals((Object)"\\", (Object)cookie.getValue());
    }

    @Test
    public void testSimpleJSONObjectInRequestCookies() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)true, Arrays.asList("CUSTOMER={\"v1\":1, \"id\":\"some_unique_id\", \"c\":\"http://www.google.com?q=love me\"}; $Domain=LOONEY_TUNES; $Version=1; $Path=/; SHIPPING=FEDEX"), (boolean)false, (boolean)true);
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"{\"v1\":1, \"id\":\"some_unique_id\", \"c\":\"http://www.google.com?q=love me\"}", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testQuotedJSONObjectInRequestCookies() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)true, Arrays.asList("CUSTOMER=\"{\\\"v1\\\":1, \\\"id\\\":\\\"some_unique_id\\\", \\\"c\\\":\\\"http://www.google.com?q=love me\\\"}\"; $Domain=LOONEY_TUNES; $Version=1; $Path=/; SHIPPING=FEDEX"), (boolean)false, (boolean)true);
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"{\"v1\":1, \"id\":\"some_unique_id\", \"c\":\"http://www.google.com?q=love me\"}", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testComplexJSONObjectInRequestCookies() {
        Map cookies = Cookies.parseRequestCookies((int)2, (boolean)false, Arrays.asList("CUSTOMER={ \"accounting\" : [ { \"firstName\" : \"John\", \"lastName\" : \"Doe\", \"age\" : 23 }, { \"firstName\" : \"Mary\",  \"lastName\" : \"Smith\", \"age\" : 32 }], \"sales\" : [ { \"firstName\" : \"Sally\", \"lastName\" : \"Green\", \"age\" : 27 }, { \"firstName\" : \"Jim\", \"lastName\" : \"Galley\", \"age\" : 41 } ] }; $Domain=LOONEY_TUNES; $Version=1; $Path=/; SHIPPING=FEDEX"), (boolean)false, (boolean)true);
        Cookie cookie = (Cookie)cookies.get("CUSTOMER");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"{ \"accounting\" : [ { \"firstName\" : \"John\", \"lastName\" : \"Doe\", \"age\" : 23 }, { \"firstName\" : \"Mary\",  \"lastName\" : \"Smith\", \"age\" : 32 }], \"sales\" : [ { \"firstName\" : \"Sally\", \"lastName\" : \"Green\", \"age\" : 27 }, { \"firstName\" : \"Jim\", \"lastName\" : \"Galley\", \"age\" : 41 } ] }", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        cookie = (Cookie)cookies.get("SHIPPING");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"LOONEY_TUNES", (Object)cookie.getDomain());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testSameSiteCookie() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_E_COYOTE; path=/; SameSite");
        Assert.assertEquals((Object)"CUSTOMER", (Object)cookie.getName());
        Assert.assertEquals((Object)"WILE_E_COYOTE", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.isSameSite());
        Assert.assertNull((Object)cookie.getSameSiteMode());
        cookie = Cookies.parseSetCookieHeader((String)"SHIPPING=FEDEX; path=/foo; SameSite=Strict");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/foo", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.isSameSite());
        Assert.assertEquals((Object)"Strict", (Object)cookie.getSameSiteMode());
        cookie = Cookies.parseSetCookieHeader((String)"SHIPPING=FEDEX; path=/acme; SameSite=Lax");
        Assert.assertEquals((Object)"SHIPPING", (Object)cookie.getName());
        Assert.assertEquals((Object)"FEDEX", (Object)cookie.getValue());
        Assert.assertEquals((Object)"/acme", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.isSameSite());
        Assert.assertEquals((Object)"Lax", (Object)cookie.getSameSiteMode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSameSiteCookie() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_E_COYOTE; path=/; SameSite=test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_ E_COYOTE; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue1() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=\"WILE_ E_COYOTE\"; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue2() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=\"WILE_\\\"E_COYOTE\"; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue3() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=\"WILE_,E_COYOTE\"; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue4() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=\"WILE_;E_COYOTE\"; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInValue5() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=\"WILE_\\E_COYOTE\"; path=/example; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInPath() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_E_COYOTE; path=\"/ex;ample\"; domain=example.com");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
        Rfc6265CookieSupport.validatePath((String)cookie.getPath());
        Rfc6265CookieSupport.validateDomain((String)cookie.getDomain());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRfc6265CookieInDomain() {
        Cookie cookie = Cookies.parseSetCookieHeader((String)"CUSTOMER=WILE_E_COYOTE; path=/example; domain=\"ex;ample.com\"");
        Rfc6265CookieSupport.validateCookieValue((String)cookie.getValue());
        Rfc6265CookieSupport.validatePath((String)cookie.getPath());
        Rfc6265CookieSupport.validateDomain((String)cookie.getDomain());
    }
}

