/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public final class HeaderValuesTestCase {
    @Test
    public void testBasic() {
        HeaderValues headerValues = new HeaderValues(Headers.DEFLATE);
        Assert.assertEquals((long)0L, (long)headerValues.size());
        Assert.assertTrue((boolean)headerValues.isEmpty());
        Assert.assertFalse((boolean)headerValues.iterator().hasNext());
        Assert.assertFalse((boolean)headerValues.descendingIterator().hasNext());
        Assert.assertFalse((boolean)headerValues.listIterator().hasNext());
        Assert.assertFalse((boolean)headerValues.listIterator(0).hasNext());
        Assert.assertNull((Object)headerValues.peek());
        Assert.assertNull((Object)headerValues.peekFirst());
        Assert.assertNull((Object)headerValues.peekLast());
    }

    @Test
    public void testAdd() {
        HeaderValues headerValues = new HeaderValues(Headers.HOST);
        Assert.assertTrue((boolean)headerValues.add("Foo"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"Foo"));
        Assert.assertTrue((boolean)headerValues.contains((Object)new String("Foo")));
        Assert.assertFalse((boolean)headerValues.contains((Object)"Bar"));
        Assert.assertFalse((boolean)headerValues.isEmpty());
        Assert.assertEquals((long)1L, (long)headerValues.size());
        Assert.assertEquals((Object)"Foo", (Object)headerValues.peek());
        Assert.assertEquals((Object)"Foo", (Object)headerValues.peekFirst());
        Assert.assertEquals((Object)"Foo", (Object)headerValues.peekLast());
        Assert.assertEquals((Object)"Foo", (Object)headerValues.get(0));
        Assert.assertTrue((boolean)headerValues.offerFirst("First!"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"First!"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"Foo"));
        Assert.assertEquals((long)2L, (long)headerValues.size());
        Assert.assertEquals((Object)"First!", (Object)headerValues.peek());
        Assert.assertEquals((Object)"First!", (Object)headerValues.peekFirst());
        Assert.assertEquals((Object)"First!", (Object)headerValues.get(0));
        Assert.assertEquals((Object)"Foo", (Object)headerValues.peekLast());
        Assert.assertEquals((Object)"Foo", (Object)headerValues.get(1));
        Assert.assertTrue((boolean)headerValues.offerLast("Last!"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"Last!"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"Foo"));
        Assert.assertTrue((boolean)headerValues.contains((Object)"First!"));
        Assert.assertEquals((long)3L, (long)headerValues.size());
        Assert.assertEquals((Object)"First!", (Object)headerValues.peek());
        Assert.assertEquals((Object)"First!", (Object)headerValues.peekFirst());
        Assert.assertEquals((Object)"First!", (Object)headerValues.get(0));
        Assert.assertEquals((Object)"Foo", (Object)headerValues.get(1));
        Assert.assertEquals((Object)"Last!", (Object)headerValues.peekLast());
        Assert.assertEquals((Object)"Last!", (Object)headerValues.get(2));
    }
}

