/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileHandlerIndexTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWelcomeFile() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryIndex() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path badSymlink = null;
        try {
            DefaultServer.setRootHandler((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true)));
            badSymlink = rootPath.resolve("tmp2");
            Path badSymlinkTarget = rootPath.resolve("/tmp2");
            Files.createSymbolicLink(badSymlink, badSymlinkTarget, new FileAttribute[0]);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("page.html"));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/.");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("page.html"));
            Assert.assertTrue((String)response, (boolean)response.contains("tmp2"));
            SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.US);
            Assert.assertTrue((String)response, (boolean)response.contains(format.format(new Date(0L))));
        }
        catch (Throwable throwable) {
            client.getConnectionManager().shutdown();
            if (badSymlink != null) {
                Files.deleteIfExists(badSymlink);
            }
            throw throwable;
        }
        client.getConnectionManager().shutdown();
        if (badSymlink != null) {
            Files.deleteIfExists(badSymlink);
        }
    }
}

