/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static String readResponse(HttpResponse response) throws IOException {
        return HttpClientUtils.readResponse(response, StandardCharsets.UTF_8);
    }

    public static String readResponse(HttpResponse response, Charset charset) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "";
        }
        return HttpClientUtils.readResponse(entity.getContent(), charset);
    }

    public static String readResponse(InputStream stream) throws IOException {
        int read;
        byte[] data = new byte[100];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = stream.read(data)) != -1) {
            out.write(data, 0, read);
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String readResponse(InputStream stream, Charset charset) throws IOException {
        int read;
        byte[] data = new byte[100];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = stream.read(data)) != -1) {
            out.write(data, 0, read);
        }
        return new String(out.toByteArray(), charset);
    }

    public static byte[] readRawResponse(HttpResponse response) throws IOException {
        return HttpClientUtils.readRawResponse(response.getEntity().getContent());
    }

    public static byte[] readRawResponse(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] data = new byte[100];
        while ((read = stream.read(data)) != -1) {
            b.write(data, 0, read);
        }
        return b.toByteArray();
    }
}

