/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.NodeTestConfig;
import io.undertow.testutils.HttpClientUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;

public class MCMPTestClient
implements Closeable {
    public static final String CONFIG = new String("CONFIG");
    public static final String ENABLE_APP = new String("ENABLE-APP");
    public static final String DISABLE_APP = new String("DISABLE-APP");
    public static final String STOP_APP = new String("STOP-APP");
    public static final String REMOVE_APP = new String("REMOVE-APP");
    public static final String STATUS = new String("STATUS");
    public static final String DUMP = new String("DUMP");
    public static final String INFO = new String("INFO");
    public static final String PING = new String("PING");
    public static final String GET = new String("GET");
    private static final String[] YES_NO = new String[]{"Yes", "No"};
    private final HttpClient client;
    private final String manager;
    private final String command;

    public MCMPTestClient(HttpClient client, String manager) {
        this.client = client;
        this.manager = manager;
        this.command = manager + "/*";
    }

    public String info() throws IOException {
        Request request = new Request(this.manager, INFO);
        HttpResponse result = this.client.execute((HttpUriRequest)request);
        return MCMPTestClient.assertResponse(result);
    }

    public String registerNode(NodeTestConfig config) throws IOException {
        Request request = new Request(this.manager, CONFIG);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        MCMPTestClient.addIfNotNull(pairs, "Balancer", config.getBalancerName());
        MCMPTestClient.addIfNotNull(pairs, "StickySessionForce", config.getStickySessionForce(), YES_NO);
        MCMPTestClient.addIfNotNull(pairs, "StickySessionCookie", config.getStickySessionCookie());
        MCMPTestClient.addIfNotNull(pairs, "JVMRoute", config.getJvmRoute());
        MCMPTestClient.addIfNotNull(pairs, "Domain", config.getDomain());
        MCMPTestClient.addIfNotNull(pairs, "Type", config.getType());
        MCMPTestClient.addIfNotNull(pairs, "Host", config.getHostname());
        MCMPTestClient.addIfNotNull(pairs, "Port", config.getPort());
        request.setEntity(MCMPTestClient.createEntity(pairs));
        HttpResponse result = this.client.execute((HttpUriRequest)request);
        return MCMPTestClient.assertResponse(result);
    }

    static void addIfNotNull(List<NameValuePair> pairs, String key, Boolean value, String[] inconsistentNames) {
        if (value != null) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, value != false ? inconsistentNames[0] : inconsistentNames[1]));
        }
    }

    static void addIfNotNull(List<NameValuePair> pairs, String key, Integer value) {
        if (value != null) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, value.toString()));
        }
    }

    static void addIfNotNull(List<NameValuePair> pairs, String key, String value) {
        if (value != null) {
            pairs.add((NameValuePair)new BasicNameValuePair(key, value));
        }
    }

    public String updateLoad(String jvmRoute, int load) throws IOException {
        Request request = new Request(this.manager, STATUS);
        request.setEntity(MCMPTestClient.createEntity(new NameValuePair[]{new BasicNameValuePair("JVMRoute", jvmRoute), new BasicNameValuePair("Load", "" + load)}));
        HttpResponse result = this.client.execute((HttpUriRequest)request);
        return MCMPTestClient.assertResponse(result);
    }

    public String removeNode(String jvmRoute) throws IOException {
        Request request = new Request(this.command, REMOVE_APP);
        request.setEntity(MCMPTestClient.createEntity(new NameValuePair[]{new BasicNameValuePair("JVMRoute", jvmRoute)}));
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return MCMPTestClient.assertResponse(response);
    }

    public String enableApp(String jvmRoute, App app) throws IOException {
        return this.enableApp(jvmRoute, app.getContext(), app.getHosts());
    }

    public String enableApp(String jvmRoute, String webApp, String ... hosts) throws IOException {
        return this.executeAppCmd(ENABLE_APP, jvmRoute, webApp, hosts);
    }

    public String disableApp(String jvmRoute, App app) throws IOException {
        return this.disableApp(jvmRoute, app.getContext(), app.getHosts());
    }

    public String disableApp(String jvmRoute, String webApp, String ... hosts) throws IOException {
        return this.executeAppCmd(DISABLE_APP, jvmRoute, webApp, hosts);
    }

    public String stopApp(String jvmRoute, App app) throws IOException {
        return this.stopApp(jvmRoute, app.getContext(), app.getHosts());
    }

    public String stopApp(String jvmRoute, String webApp, String ... hosts) throws IOException {
        return this.executeAppCmd(STOP_APP, jvmRoute, webApp, hosts);
    }

    public String removeApp(String jvmRoute, App app) throws IOException {
        return this.removeApp(jvmRoute, app.getContext(), app.getHosts());
    }

    public String removeApp(String jvmRoute, String webApp, String ... hosts) throws IOException {
        return this.executeAppCmd(REMOVE_APP, jvmRoute, webApp, hosts);
    }

    public String ping(String scheme, String hostname, int port) throws IOException {
        Request request = new Request(this.manager, PING);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        MCMPTestClient.addIfNotNull(pairs, "Scheme", scheme);
        MCMPTestClient.addIfNotNull(pairs, "Host", hostname);
        MCMPTestClient.addIfNotNull(pairs, "Port", port);
        request.setEntity(MCMPTestClient.createEntity(pairs));
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        return HttpClientUtils.readResponse(response);
    }

    String executeAppCmd(String command, String jvmRoute, String webApp, String ... hosts) throws IOException {
        Request request = new Request(this.manager, command);
        request.setEntity(MCMPTestClient.createEntity(new NameValuePair[]{new BasicNameValuePair("JVMRoute", jvmRoute), new BasicNameValuePair("context", webApp), new BasicNameValuePair("Alias", this.asString(Arrays.asList(hosts)))}));
        HttpResponse result = this.client.execute((HttpUriRequest)request);
        return MCMPTestClient.assertResponse(result);
    }

    @Override
    public void close() throws IOException {
        this.client.getConnectionManager().shutdown();
    }

    static String assertResponse(HttpResponse result) throws IOException {
        String response = HttpClientUtils.readResponse(result);
        Assert.assertEquals((String)response, (long)200L, (long)result.getStatusLine().getStatusCode());
        return response;
    }

    static HttpEntity createEntity(NameValuePair ... pairs) throws UnsupportedEncodingException {
        return MCMPTestClient.createEntity(Arrays.asList(pairs));
    }

    static HttpEntity createEntity(List<NameValuePair> pairs) throws UnsupportedEncodingException {
        return new UrlEncodedFormEntity(pairs, StandardCharsets.US_ASCII);
    }

    String asString(List<String> names) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> i = names.iterator();
        while (i.hasNext()) {
            builder.append(i.next());
            if (!i.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    static class App {
        private final String context;
        private final String[] hosts;

        App(String context, String ... hosts) {
            this.context = context;
            this.hosts = hosts;
        }

        public String getContext() {
            return this.context;
        }

        public String[] getHosts() {
            return this.hosts;
        }
    }

    static class Request
    extends HttpPost {
        private final String name;

        Request(String uri, String name) {
            this(URI.create(uri), name);
        }

        Request(URI uri, String name) {
            super(uri);
            this.name = name;
        }

        public String getMethod() {
            return this.name;
        }
    }
}

