/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ClientCertTestCase
extends AuthenticationTestBase {
    private static SSLContext clientSSLContext;

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        ClientCertAuthenticationMechanism mechanism = new ClientCertAuthenticationMechanism();
        return Collections.singletonList(mechanism);
    }

    @BeforeClass
    public static void startSSL() throws Exception {
        DefaultServer.startSSLServer();
        clientSSLContext = DefaultServer.getClientSSLContext();
    }

    @AfterClass
    public static void stopSSL() throws Exception {
        clientSSLContext = null;
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testClientCertSuccess() throws Exception {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(clientSSLContext);
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((String)"ProcessedBy Headers", (long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        values = result.getHeaders("AuthenticatedUser");
        Assert.assertEquals((String)"AuthenticatedUser Headers", (long)1L, (long)values.length);
        Assert.assertEquals((Object)"CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB", (Object)values[0].getValue());
        HttpClientUtils.readResponse((HttpResponse)result);
        ClientCertTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }
}

