/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.URLUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={UnitTest.class})
public class URLUtilsTestCase {
    @Parameterized.Parameter
    public String spaceCode = "%2f";

    @Parameterized.Parameters
    public static Object[] spaceCodes() {
        return new Object[]{"%2f", "%2F"};
    }

    @Test
    public void testDecodingWithEncodedAndDecodedSlashAndSlashDecodingDisabled() throws Exception {
        String url = "http://localhost:3001/by-path/wild%20card/wild%28west%29/wild" + this.spaceCode + "wolf";
        String result = URLUtils.decode((String)url, (String)Charset.defaultCharset().name(), (boolean)false, (StringBuilder)new StringBuilder());
        Assert.assertEquals((Object)("http://localhost:3001/by-path/wild card/wild(west)/wild" + this.spaceCode + "wolf"), (Object)result);
    }

    @Test
    public void testDecodingURLMustNotMutateSpaceSymbolsCaseIfSpaceDecodingDisabled() throws Exception {
        String url = "http://localhost:3001/wild" + this.spaceCode + "west";
        String result = URLUtils.decode((String)url, (String)Charset.defaultCharset().name(), (boolean)false, (StringBuilder)new StringBuilder());
        Assert.assertEquals((Object)url, (Object)result);
    }

    @Test
    public void testIsAbsoluteUrlRecognizingAbsolutUrls() {
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"https://some.valid.url:8080/path?query=val"));
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"http://some.valid.url:8080/path?query=val"));
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"http://some.valid.url"));
    }

    @Test
    public void testIsAbsoluteUrlRecognizingAppUrls() {
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"com.example.app:/oauth2redirect/example-provider"));
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"com.example.app:/oauth2redirect/example-provider?query=val"));
    }

    @Test
    public void testIsAbsoluteUrlRecognizingRelativeUrls() {
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)"relative"));
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)"relative/path"));
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)"relative/path?query=val"));
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)"relative/path:path"));
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)"/root/relative/path"));
    }

    @Test
    public void testIsAbsoluteUrlRecognizingEmptyOrNullAsRelative() {
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl(null));
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)""));
    }

    @Test
    public void testIsAbsoluteUrlIgnoresSyntaxErrorsAreNotAbsolute() {
        Assert.assertFalse((boolean)URLUtils.isAbsoluteUrl((String)":"));
    }

    @Test
    public void testDecodingWithTrailingPercentChar() throws Exception {
        String[] urls;
        for (String url : urls = new String[]{"https://example.com/?a=%", "https://example.com/?a=%2"}) {
            try {
                URLUtils.decode((String)url, (String)StandardCharsets.UTF_8.name(), (boolean)false, (StringBuilder)new StringBuilder());
                Assert.fail((String)("Decode was expected to fail for " + url));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIsAbsoluteUrlInvalidChars() {
        Assert.assertTrue((boolean)URLUtils.isAbsoluteUrl((String)"http://test.com/foobar?test={abc}"));
    }
}

