/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class Http2EndExchangeTestCase {
    private static final Logger log = Logger.getLogger(Http2EndExchangeTestCase.class);
    private static final String message = "Hello World!";
    public static final String MESSAGE = "/message";
    public static final String POST = "/post";
    private static final OptionMap DEFAULT_OPTIONS;
    private static URI ADDRESS;
    private static final AttachmentKey<String> RESPONSE_BODY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2EndExchangeWithBrokenConnection() throws Exception {
        int port = DefaultServer.getHostPort("default");
        final CountDownLatch requestStartedLatch = new CountDownLatch(1);
        final CompletableFuture testResult = new CompletableFuture();
        Undertow server = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)new BlockingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!exchange.getProtocol().equals(Protocols.HTTP_2_0)) {
                    throw new RuntimeException("Not HTTP/2");
                }
                requestStartedLatch.countDown();
                log.debug((Object)"Received Request");
                Thread.sleep(2000L);
                if (exchange.isComplete()) {
                    testResult.complete("FAILED, exchange ended in the background");
                    return;
                }
                try {
                    exchange.getOutputStream().write("Bogus Data".getBytes(StandardCharsets.UTF_8));
                    exchange.getOutputStream().flush();
                    testResult.complete("FAILED, should not have completed successfully");
                    return;
                }
                catch (IOException iOException) {
                    if (!exchange.isComplete()) {
                        testResult.complete("Failed, should have completed the exchange");
                    } else {
                        testResult.complete("PASSED");
                    }
                    return;
                }
            }
        })).build();
        server.start();
        try {
            ADDRESS = new URI("https://" + DefaultServer.getHostAddress() + ":" + (port + 1));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Xnio xnio = Xnio.getInstance();
        XnioWorker xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
        try {
            UndertowClient client = Http2EndExchangeTestCase.createClient();
            final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, xnioWorker, (XnioSsl)new UndertowXnioSsl(xnioWorker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
            try {
                connection.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(Http2EndExchangeTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(final ClientExchange result) {
                                try {
                                    log.debug((Object)"Callback invoked");
                                    new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                requestStartedLatch.await(10L, TimeUnit.SECONDS);
                                                result.getRequestChannel().getIoThread().execute(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        IoUtils.safeClose((Closeable)result.getConnection());
                                                        log.debug((Object)"Closed Connection");
                                                    }
                                                });
                                            }
                                            catch (Exception e) {
                                                testResult.completeExceptionally(e);
                                            }
                                        }
                                    }).start();
                                }
                                catch (Exception e) {
                                    testResult.completeExceptionally(e);
                                }
                            }

                            public void failed(IOException e) {
                                testResult.completeExceptionally(e);
                            }
                        });
                    }
                });
                Assert.assertEquals((Object)"PASSED", testResult.get(10L, TimeUnit.SECONDS));
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            xnioWorker.shutdownNow();
            server.stop();
        }
    }

    static UndertowClient createClient() {
        return Http2EndExchangeTestCase.createClient(OptionMap.EMPTY);
    }

    static UndertowClient createClient(OptionMap options) {
        return UndertowClient.getInstance();
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
    }
}

