/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.RouteIteratorFactory;
import io.undertow.server.handlers.proxy.RouteParsingStrategy;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class RouteIteratorFactoryTestCase {
    @Test
    public void testModJkLikeRouteParsing() {
        Iterator ri = new RouteIteratorFactory(RouteParsingStrategy.NONE, RouteIteratorFactory.ParsingCompatibility.MOD_JK).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.domain");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_JK).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_JK).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.domain1.something");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_JK, ".").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_JK, ".").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.node2.node3");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node2", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node3", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
    }

    @Test
    public void testModClusterRouteParsing() {
        Iterator ri = new RouteIteratorFactory(RouteParsingStrategy.NONE, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.NONE, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.node2");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER).iterator(null);
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER).iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.node2.node3");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1.node2.node3", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER, ".").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h");
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER, ".").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1.node2.node3");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node2", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node3", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER, ":").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1:node2.1:node3.1");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node2.1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node3.1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER, ":").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1::node2::");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node2", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
        ri = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_CLUSTER, "|||").iterator("mKaJwtWjqgxFbSSlaKZeGly_RMPKCg13JXe-6R_h.node1|||node2|||node3");
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node1", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node2", (Object)((CharSequence)ri.next()).toString());
        Assert.assertTrue((boolean)ri.hasNext());
        Assert.assertEquals((Object)"node3", (Object)((CharSequence)ri.next()).toString());
        Assert.assertFalse((boolean)ri.hasNext());
    }
}

