/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class HttpStringTestCase {
    @Test
    public void testOrderShorterFirst() {
        HttpString a = new HttpString("a");
        HttpString aa = new HttpString("aa");
        Assert.assertEquals((long)-1L, (long)a.compareTo(aa));
    }

    @Test
    public void testCompareShorterFirst() {
        HttpString accept = new HttpString("Accept");
        Assert.assertEquals((long)accept.compareTo(Headers.ACCEPT_CHARSET), (long)Headers.ACCEPT.compareTo(Headers.ACCEPT_CHARSET));
        HttpString acceptCharset = new HttpString("Accept-Charset");
        Assert.assertEquals((long)acceptCharset.compareTo(Headers.ACCEPT), (long)Headers.ACCEPT_CHARSET.compareTo(Headers.ACCEPT));
    }

    @Test
    public void testCompare() {
        HttpString contentType = new HttpString("Content-Type");
        Assert.assertEquals((long)contentType.compareTo(Headers.COOKIE), (long)Headers.CONTENT_TYPE.compareTo(Headers.COOKIE));
        HttpString cookie = new HttpString("Cookie");
        Assert.assertEquals((long)cookie.compareTo(Headers.CONTENT_TYPE), (long)Headers.COOKIE.compareTo(Headers.CONTENT_TYPE));
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream so = new ObjectOutputStream(out);
        HttpString testString = new HttpString("test");
        so.writeObject(testString);
        so.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        Object res = in.readObject();
        Assert.assertEquals((Object)testString, (Object)res);
    }
}

