/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.BlockingReadTimeoutHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.channels.ReadTimeoutException;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class BlockingReadTimeoutHandlerTestCase {
    private static final OutputStream STUB_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(byte[] var1, int var2, int var3) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    };
    private volatile Exception exception;
    private static final CountDownLatch errorLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeout() throws InterruptedException {
        DefaultServer.setRootHandler(BlockingReadTimeoutHandler.builder().nextHandler((HttpHandler)new BlockingHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                try {
                    IOUtils.copyLarge((InputStream)exchange.getInputStream(), (OutputStream)STUB_OUTPUT_STREAM);
                    exchange.getOutputStream().write("COMPLETED".getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    BlockingReadTimeoutHandlerTestCase.this.exception = e;
                    errorLatch.countDown();
                }
            }
        })).readTimeout(Duration.ofMillis(1L)).build());
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new AbstractHttpEntity(){

                public InputStream getContent() throws IOException, IllegalStateException {
                    return null;
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    for (int i = 0; i < 5; ++i) {
                        outstream.write(42);
                        outstream.flush();
                        try {
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return 5L;
                }
            });
            post.addHeader("Connection", "close");
            try {
                client.execute((HttpUriRequest)post);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                Assert.assertEquals(ReadTimeoutException.class, this.exception.getClass());
            } else {
                Assert.fail((String)"Read did not time out");
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

