/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.testutils.DebuggingSlicePool;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class H2CUpgradeContinuationTestCase {
    private static final String HEADER_PREFFIX = "custom-header-";
    private static final String ECHO_PATH = "/echo";
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static ByteBufferPool smallPool;
    private static XnioWorker worker;
    private static Undertow server;

    private static void sendEchoResponse(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        for (HeaderValues header : exchange.getRequestHeaders()) {
            if (!header.getFirst().startsWith(HEADER_PREFFIX)) continue;
            exchange.getResponseHeaders().putAll(header.getHeaderName(), (Collection)header.subList(0, header.size()));
        }
        if (exchange.getRequestContentLength() > 0L) {
            exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                public void handle(HttpServerExchange exchange, String message) {
                    exchange.getResponseSender().send(message);
                }
            });
        } else {
            Sender sender = exchange.getResponseSender();
            sender.send("");
        }
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        smallPool = new DebuggingSlicePool((ByteBufferPool)new DefaultByteBufferPool(true, 1024, 1000, 10, 100));
        PathHandler path = new PathHandler().addExactPath(ECHO_PATH, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                H2CUpgradeContinuationTestCase.sendEchoResponse(exchange);
            }
        });
        server = Undertow.builder().setByteBufferPool(smallPool).addHttpListener(DefaultServer.getHostPort("default") + 1, DefaultServer.getHostAddress("default"), (HttpHandler)new Http2UpgradeHandler((HttpHandler)path)).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).build();
        server.start();
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).getMap());
    }

    @AfterClass
    public static void afterClass() {
        if (server != null) {
            server.stop();
        }
        if (worker != null) {
            worker.shutdown();
        }
        if (smallPool != null) {
            smallPool.close();
            smallPool = null;
        }
    }

    private void sendRequest(final ClientConnection connection, final int requestCount, final int headersCount, final int contentLength) throws Exception {
        final CountDownLatch latch = new CountDownLatch(requestCount);
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < contentLength; ++i) {
            sb.append(i % 10);
        }
        final String content = sb.length() > 0 ? sb.toString() : null;
        connection.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < requestCount; ++i) {
                    ClientRequest request = new ClientRequest().setMethod(contentLength > 0 ? Methods.POST : Methods.GET).setPath(H2CUpgradeContinuationTestCase.ECHO_PATH);
                    request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                    if (contentLength > 0) {
                        request.getRequestHeaders().put(Headers.CONTENT_LENGTH, (long)contentLength);
                    }
                    for (int j = 0; j < headersCount; ++j) {
                        request.getRequestHeaders().put(new HttpString(H2CUpgradeContinuationTestCase.HEADER_PREFFIX + j), H2CUpgradeContinuationTestCase.HEADER_PREFFIX + j);
                    }
                    connection.sendRequest(request, H2CUpgradeContinuationTestCase.createClientCallback(responses, latch, content));
                }
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"No responses received from server in 10s", (long)requestCount, (long)responses.size());
        for (int i = 0; i < requestCount; ++i) {
            Assert.assertEquals((String)("Response " + i + " code was not OK"), (long)200L, (long)((ClientResponse)responses.get(i)).getResponseCode());
            Assert.assertEquals((String)("Incorrect data received for response " + i), (Object)(contentLength > 0 ? content : ""), (Object)((ClientResponse)responses.get(i)).getAttachment(RESPONSE_BODY));
            int headersReturned = 0;
            for (HeaderValues header : ((ClientResponse)responses.get(i)).getResponseHeaders()) {
                if (!header.getFirst().startsWith(HEADER_PREFFIX)) continue;
                headersReturned += header.size();
            }
            Assert.assertEquals((String)("Incorrect number of headers returned for response " + i), (long)headersCount, (long)headersReturned);
        }
    }

    @Test
    public void testDifferentSizes() throws Exception {
        UndertowClient client = UndertowClient.getInstance();
        ClientConnection connection = (ClientConnection)client.connect(new URI("http://" + DefaultServer.getHostAddress() + ":" + (DefaultServer.getHostPort("default") + 1)), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), smallPool, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).get();
        try {
            this.sendRequest(connection, 1, 0, 0);
            this.sendRequest(connection, 10, 10, 0);
            this.sendRequest(connection, 10, 100, 0);
            this.sendRequest(connection, 10, 150, 0);
            this.sendRequest(connection, 10, 1, 10);
            this.sendRequest(connection, 10, 0, 2000);
            this.sendRequest(connection, 10, 150, 2000);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    private static ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch, final String message) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                if (message != null) {
                    new StringWriteChannelListener(message).setup(result.getRequestChannel());
                }
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }
}

