/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.StopServerWithExternalWorkerUtils;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class HttpClientTestCase {
    private static final String message = "Hello World!";
    public static final String MESSAGE = "/message";
    public static final String READTIMEOUT = "/readtimeout";
    public static final String READTIMEOUT_AT_INIT = "/readtimeout-init";
    public static final String POST = "/post";
    private static XnioWorker worker;
    private static final OptionMap DEFAULT_OPTIONS;
    private static final URI ADDRESS;
    private static final AttachmentKey<String> RESPONSE_BODY;
    private IOException exception;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
        DefaultServer.setRootHandler((HttpHandler)new PathHandler().addExactPath(MESSAGE, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                HttpClientTestCase.sendMessage(exchange);
            }
        }).addExactPath(READTIMEOUT, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setStatusCode(200);
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "5");
                try (StreamSinkChannel responseChannel = exchange.getResponseChannel();){
                    responseChannel.write(ByteBuffer.wrap(new byte[]{97, 98, 99}));
                    responseChannel.flush();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    responseChannel.write(ByteBuffer.wrap(new byte[]{100, 101}));
                }
            }
        }).addExactPath(READTIMEOUT_AT_INIT, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                exchange.setStatusCode(200);
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "5");
                try (StreamSinkChannel responseChannel = exchange.getResponseChannel();){
                    responseChannel.write(ByteBuffer.wrap(new byte[]{97, 98, 99, 100, 101}));
                }
            }
        }).addExactPath(POST, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                    public void handle(HttpServerExchange exchange, String message) {
                        exchange.getResponseSender().send(message);
                    }
                });
            }
        }));
    }

    @AfterClass
    public static void afterClass() {
        StopServerWithExternalWorkerUtils.stopWorker(worker);
    }

    static UndertowClient createClient() {
        return HttpClientTestCase.createClient(OptionMap.EMPTY);
    }

    static UndertowClient createClient(OptionMap options) {
        return UndertowClient.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasic() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(HttpClientTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, HttpClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostRequest() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        String postMessage = "This is a post request";
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        final ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(HttpClientTestCase.POST);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                        connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                            public void completed(ClientExchange result) {
                                new StringWriteChannelListener("This is a post request").setup(result.getRequestChannel());
                                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                                    public void completed(ClientExchange result) {
                                        new StringReadChannelListener(DefaultServer.getBufferPool()){

                                            protected void stringDone(String string) {
                                                responses.add(string);
                                                latch.countDown();
                                            }

                                            protected void error(IOException e) {
                                                e.printStackTrace();
                                                latch.countDown();
                                            }
                                        }.setup(result.getResponseChannel());
                                    }

                                    public void failed(IOException e) {
                                        e.printStackTrace();
                                        latch.countDown();
                                    }
                                });
                            }

                            public void failed(IOException e) {
                                e.printStackTrace();
                                latch.countDown();
                            }
                        });
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (String response : responses) {
                Assert.assertEquals((Object)"This is a post request", (Object)response);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSsl() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        final CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        final CountDownLatch latch = new CountDownLatch(10);
        DefaultServer.startSSLServer();
        SSLContext context = DefaultServer.getClientSSLContext();
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (ByteBufferPool)DefaultServer.SSL_BUFFER_POOL, context);
        final ClientConnection connection = (ClientConnection)client.connect(new URI(DefaultServer.getDefaultServerSSLAddress()), worker, (XnioSsl)ssl, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            connection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(HttpClientTestCase.MESSAGE);
                        request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                        connection.sendRequest(request, HttpClientTestCase.this.createClientCallback(responses, latch));
                    }
                }
            });
            latch.await(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10L, (long)responses.size());
            for (ClientResponse response : responses) {
                Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            }
        }
        catch (Throwable throwable) {
            connection.getIoThread().execute(new Runnable(connection){
                final /* synthetic */ ClientConnection val$connection;
                {
                    this.val$connection = clientConnection;
                }

                @Override
                public void run() {
                    IoUtils.safeClose((Closeable)this.val$connection);
                }
            });
            DefaultServer.stopSSLServer();
            throw throwable;
        }
        connection.getIoThread().execute(new /* invalid duplicate definition of identical inner class */);
        DefaultServer.stopSSLServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionClose() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), OptionMap.EMPTY).get();
        try {
            ClientRequest request = new ClientRequest().setPath(MESSAGE).setMethod(Methods.GET);
            request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
            CopyOnWriteArrayList<ClientResponse> responses = new CopyOnWriteArrayList<ClientResponse>();
            request.getRequestHeaders().add(Headers.CONNECTION, Headers.CLOSE.toString());
            connection.sendRequest(request, this.createClientCallback(responses, latch));
            latch.await();
            ClientResponse response = (ClientResponse)responses.iterator().next();
            Assert.assertEquals((Object)message, (Object)response.getAttachment(RESPONSE_BODY));
            Assert.assertEquals((Object)false, (Object)connection.isOpen());
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeout() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        this.exception = null;
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.READ_TIMEOUT, 600);
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), builder.getMap()).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(READTIMEOUT);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)(this.exception instanceof ReadTimeoutException));
        }
        finally {
            connection.getIoThread().execute(() -> IoUtils.safeClose((Closeable)connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeoutAtInit() throws Exception {
        UndertowClient client = HttpClientTestCase.createClient();
        this.exception = null;
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        OptionMap.Builder builder = OptionMap.builder().set(Options.READ_TIMEOUT, 600);
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS, worker, DefaultServer.getBufferPool(), builder.getMap()).get();
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(READTIMEOUT_AT_INIT);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(responses, latch));
            });
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)(this.exception instanceof ReadTimeoutException));
        }
        finally {
            connection.getIoThread().execute(() -> IoUtils.safeClose((Closeable)connection));
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                responses.add(result.getResponse());
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                e.printStackTrace();
                                HttpClientTestCase.this.exception = e;
                                responses.add(result.getResponse());
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        HttpClientTestCase.this.exception = e;
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    HttpClientTestCase.this.exception = e;
                    e.printStackTrace();
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                HttpClientTestCase.this.exception = e;
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        RESPONSE_BODY = AttachmentKey.create(String.class);
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
        try {
            ADDRESS = new URI(DefaultServer.getDefaultServerURL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

