/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http2.HTTP2ViaUpgradeTestCase;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.protocol.http2.Http2UpgradeHandler;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.HttpString;
import java.net.URISyntaxException;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.xnio.Options;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class HTTP2ViaUpgradeWithUnEncodedURLCharactersTestCase
extends HTTP2ViaUpgradeTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        server = Undertow.builder().addHttpListener(port + 1, DefaultServer.getHostAddress("default")).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.header((HttpHandler)new Http2UpgradeHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                exchange.getResponseSender().send(HTTP2ViaUpgradeTestCase.message);
            }
        }, new String[]{"h2c", "h2c-17"}), (String)"Sec-WebSocket-Accept", (String)"fake")).build();
        server.start();
    }

    protected String fetchUpgradeHandlerURL() {
        return "/^?query=^";
    }
}

