/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.io.Receiver;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class NewlineInHeadersTestCase {
    private static final String RESPONSE = "response";
    private static final String ECHO = "echo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewlineInHeaders() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getRequestReceiver().receiveFullString(new Receiver.FullStringCallback(){

                    public void handle(HttpServerExchange exchange, String message) {
                        exchange.getResponseHeaders().put(HttpString.tryFromString((String)NewlineInHeadersTestCase.ECHO), message);
                        exchange.getResponseSender().send(NewlineInHeadersTestCase.RESPONSE);
                    }
                });
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new StringEntity("test"));
            CloseableHttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"test", (Object)result.getFirstHeader(ECHO).getValue());
            Assert.assertEquals((Object)RESPONSE, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new StringEntity("test\nnewline"));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"test newline", (Object)result.getFirstHeader(ECHO).getValue());
            Assert.assertEquals((Object)RESPONSE, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

