/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleSSLTestCase {
    private static final int CONCURRENCY = Math.min(32, Runtime.getRuntime().availableProcessors() * 8);
    private static final int REQUESTS_PER_THREAD = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleSSLTestCase() throws IOException, GeneralSecurityException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.endExchange();
            }
        });
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("scheme");
            Assert.assertEquals((Object)"https", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonPersistentConnections() throws IOException, GeneralSecurityException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
                exchange.endExchange();
            }
        });
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            for (int i = 0; i < 5; ++i) {
                HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
                CloseableHttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Header[] header = result.getHeaders("scheme");
                Assert.assertEquals((Object)"https", (Object)header[0].getValue());
                HttpClientUtils.readResponse((HttpResponse)result);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }

    @Test
    public void parallel() throws Exception {
        this.runTest(CONCURRENCY, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.endExchange();
            }
        });
    }

    @Test
    public void parallelWithDispatch() throws Exception {
        this.runTest(CONCURRENCY, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.dispatch(() -> {
                    exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                    exchange.endExchange();
                });
            }
        });
    }

    @Test
    public void parallelWithBlockingDispatch() throws Exception {
        this.runTest(CONCURRENCY, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.isInIoThread()) {
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                exchange.startBlocking();
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.endExchange();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(int concurrency, HttpHandler handler) throws IOException, InterruptedException {
        DefaultServer.setRootHandler(handler);
        DefaultServer.startSSLServer();
        ExecutorService executorService = Executors.newFixedThreadPool(concurrency);
        try (final CloseableHttpClient client = HttpClients.custom().disableConnectionState().setSSLContext(DefaultServer.getClientSSLContext()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(60000).build()).setMaxConnPerRoute(1000).build();){
            final AtomicBoolean failed = new AtomicBoolean();
            final AtomicInteger processed = new AtomicInteger(0);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block15: {
                        if (failed.get()) {
                            return;
                        }
                        try (CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerSSLAddress()));){
                            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                            Header[] header = result.getHeaders("scheme");
                            Assert.assertEquals((Object)"https", (Object)header[0].getValue());
                            EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
                            processed.incrementAndGet();
                        }
                        catch (Throwable t) {
                            if (!failed.compareAndSet(false, true)) break block15;
                            t.printStackTrace();
                        }
                    }
                }
            };
            for (int i = 0; i < concurrency * 300; ++i) {
                executorService.submit(task);
            }
            executorService.shutdown();
            int executedPrevTime = 0;
            while (!executorService.awaitTermination(10L, TimeUnit.SECONDS) && !failed.get()) {
                int executed = processed.get();
                if (executedPrevTime == executed) {
                    failed.set(true);
                    Assert.fail((String)("Executions hanged at " + executed));
                }
                executedPrevTime = executed;
            }
            Assert.assertFalse((String)"A task failed! Check the stack-trace in the output file", (boolean)failed.get());
            Assert.assertTrue((boolean)executorService.isTerminated());
        }
        finally {
            DefaultServer.stopSSLServer();
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }
}

