/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.testutils.category.UnitTest;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public final class HeaderMapTestCase {
    private static final List<HttpString> HTTP_STRING_LIST = Arrays.asList(Headers.CONNECTION, Headers.HOST, Headers.UPGRADE, Headers.CONTENT_MD5, Headers.KEEP_ALIVE, Headers.RESPONSE_AUTH, Headers.CONTENT_DISPOSITION, Headers.DEFLATE, Headers.NEGOTIATE, Headers.USER_AGENT, Headers.REFERER, Headers.TRANSFER_ENCODING, Headers.FROM);

    @Test
    public void testInitial() {
        HeaderMap headerMap = new HeaderMap();
        Assert.assertEquals((long)0L, (long)headerMap.size());
        Assert.assertEquals((long)-1L, (long)headerMap.fastIterate());
        Assert.assertFalse((boolean)headerMap.iterator().hasNext());
    }

    @Test
    public void testMixedCase() {
        HeaderMap headerMap = new HeaderMap();
        headerMap.add(new HttpString("Aa"), "A");
        headerMap.add(new HttpString("aa"), "a");
        Assert.assertArrayEquals((Object[])headerMap.get(new HttpString("aa")).toArray(), (Object[])new String[]{"A", "a"});
        Assert.assertArrayEquals((Object[])headerMap.get(new HttpString("Aa")).toArray(), (Object[])new String[]{"A", "a"});
        Assert.assertArrayEquals((Object[])headerMap.get(new HttpString("AA")).toArray(), (Object[])new String[]{"A", "a"});
    }

    @Test
    public void testSimple() {
        HeaderMap headerMap = new HeaderMap();
        headerMap.add(Headers.HOST, "yay.undertow.io");
        Assert.assertTrue((boolean)headerMap.contains(Headers.HOST));
        Assert.assertTrue((boolean)headerMap.contains("host"));
        Assert.assertEquals((long)1L, (long)headerMap.size());
        Assert.assertNotEquals((long)-1L, (long)headerMap.fastIterate());
        Assert.assertEquals((long)-1L, (long)headerMap.fiNext(headerMap.fastIterate()));
        Assert.assertEquals((Object)Headers.HOST, (Object)headerMap.fiCurrent(headerMap.fastIterate()).getHeaderName());
        Assert.assertEquals((Object)"yay.undertow.io", (Object)headerMap.getFirst(Headers.HOST));
        Assert.assertEquals((Object)"yay.undertow.io", (Object)headerMap.getLast(Headers.HOST));
        Assert.assertEquals((Object)"yay.undertow.io", (Object)headerMap.get(Headers.HOST, 0));
        headerMap.remove("host");
        Assert.assertEquals((long)0L, (long)headerMap.size());
    }

    @Test
    public void testGrowing() {
        HeaderMap headerMap = new HeaderMap();
        for (HttpString item : HTTP_STRING_LIST) {
            for (int i = 0; i < (item.hashCode() & 7) + 1; ++i) {
                headerMap.add(item, "Test value");
            }
        }
        for (HttpString item : HTTP_STRING_LIST) {
            Assert.assertTrue((String)String.format("Missing %s (hash %08x)", item, item.hashCode()), (boolean)headerMap.contains(item));
            Assert.assertNotNull((Object)headerMap.get(item));
            Assert.assertEquals((long)((item.hashCode() & 7) + 1), (long)headerMap.get(item).size());
            Assert.assertEquals((Object)"Test value", (Object)headerMap.getFirst(item));
            Assert.assertEquals((Object)"Test value", (Object)headerMap.getLast(item));
        }
        Assert.assertEquals((long)HTTP_STRING_LIST.size(), (long)headerMap.size());
        for (HttpString item : HTTP_STRING_LIST) {
            Assert.assertTrue((boolean)headerMap.contains(item));
            Assert.assertNotNull((Object)headerMap.remove(item));
            Assert.assertFalse((boolean)headerMap.contains(item));
        }
        Assert.assertEquals((long)0L, (long)headerMap.size());
    }

    @Test
    public void testCollision() {
        HeaderMap headerMap = new HeaderMap();
        headerMap.put(new HttpString("Link"), "a");
        headerMap.put(new HttpString("Rest"), "b");
        Assert.assertEquals((Object)"a", (Object)headerMap.getFirst(new HttpString("Link")));
        Assert.assertEquals((Object)"b", (Object)headerMap.getFirst(new HttpString("Rest")));
        Assert.assertEquals((Object)"a", (Object)headerMap.getFirst("Link"));
        Assert.assertEquals((Object)"b", (Object)headerMap.getFirst("Rest"));
    }

    @Test
    public void testContainsAfterClear() {
        HeaderMap headerMap = new HeaderMap();
        HttpString header = Headers.HOST;
        headerMap.put(header, "a");
        headerMap.get(header).clear();
        Assert.assertFalse((boolean)headerMap.contains(header));
        Assert.assertFalse((boolean)headerMap.contains(header.toString()));
    }
}

