/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ResourcePredicateHandlerTestCase {
    private static final String DIR_PREFIXED = "prefix-resource-dir";
    private static final String DIR_PATH = "path-resource-dir";
    private static final String FILE_NAME_LEVEL_0 = "file0";
    private static final String FILE_NAME_LEVEL_1 = "file1";
    private static final String DIR_SUB = "sub_dir";
    private static final String GIBBERISH = "Gibberish, what did you expect?";
    private static final String TEST_PREFIX = "prefixToTest";

    @Test
    public void testPrefixMatchWithURIAltering() throws IOException {
        PathsRetainer pathsRetainer = this.createTestDir(DIR_PREFIXED, false);
        DefaultServer.setRootHandler((HttpHandler)Handlers.predicates((List)PredicatedHandlersParser.parse((String)("path-prefix(/prefixToTest)-> { set(attribute=%U,value=${remaining}); resource(location='" + pathsRetainer.root.toString() + "',allow-listing=true) }"), (ClassLoader)this.getClass().getClassLoader()), (HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
            }
        }));
        this.testURLListing(pathsRetainer, true);
    }

    @Test
    public void testPrefixMatchNoURIAltering() throws IOException {
        PathsRetainer pathsRetainer = this.createTestDir(DIR_PREFIXED, true);
        DefaultServer.setRootHandler((HttpHandler)Handlers.predicates((List)PredicatedHandlersParser.parse((String)("path-prefix(/prefixToTest)-> { resource(location='" + pathsRetainer.root.toString() + "',allow-listing=true) }"), (ClassLoader)this.getClass().getClassLoader()), (HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
            }
        }));
        this.testURLListing(pathsRetainer, true);
    }

    @Test
    public void testPathMatchNoURIAltering() throws IOException {
        PathsRetainer pathsRetainer = this.createTestDir(DIR_PATH, true);
        ArrayList lst = new ArrayList();
        lst.addAll(PredicatedHandlersParser.parse((String)("path(/prefixToTest)-> { resource(location='" + pathsRetainer.root.toString() + "',allow-listing=true)"), (ClassLoader)this.getClass().getClassLoader()));
        lst.addAll(PredicatedHandlersParser.parse((String)("path(/prefixToTest/" + pathsRetainer.sub.getFileName() + ")-> { resource(location='" + pathsRetainer.root.toString() + "',allow-listing=true) }"), (ClassLoader)this.getClass().getClassLoader()));
        DefaultServer.setRootHandler((HttpHandler)Handlers.predicates(lst, (HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Assert.assertFalse((boolean)true);
            }
        }));
        this.testURLListing(pathsRetainer, false);
    }

    private void testURLListing(PathsRetainer pathsRetainer, boolean testFile) throws IOException {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + TEST_PREFIX + "/");
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String bodyToTest = EntityUtils.toString((HttpEntity)result.getEntity());
        Assert.assertTrue((boolean)bodyToTest.contains("href='/prefixToTest/" + pathsRetainer.sub.getFileName() + "/'>" + pathsRetainer.sub.getFileName() + "</a>"));
        Assert.assertTrue((boolean)bodyToTest.contains("href='/prefixToTest/" + pathsRetainer.rootFile.getFileName() + "'>" + pathsRetainer.rootFile.getFileName() + "</a>"));
        get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + TEST_PREFIX + "/" + pathsRetainer.sub.getFileName() + "/");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        bodyToTest = EntityUtils.toString((HttpEntity)result.getEntity());
        Assert.assertTrue((boolean)bodyToTest.contains("href='/prefixToTest/'>[..]</a>"));
        Assert.assertTrue((boolean)bodyToTest.contains("href='/prefixToTest/" + pathsRetainer.sub.getFileName() + "/" + pathsRetainer.subFile.getFileName() + "'>" + pathsRetainer.subFile.getFileName() + "</a>"));
        if (testFile) {
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/" + TEST_PREFIX + "/" + pathsRetainer.sub.getFileName() + "/" + pathsRetainer.subFile.getFileName());
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            bodyToTest = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)GIBBERISH, (Object)bodyToTest);
        }
    }

    private PathsRetainer createTestDir(String dirName, boolean prefixDirectory) throws IOException {
        FileAttribute[] attribs = new FileAttribute[]{};
        PathsRetainer pathsRetainer = new PathsRetainer();
        Path dir = Files.createTempDirectory(dirName, new FileAttribute[0]);
        if (prefixDirectory) {
            File f = dir.toFile();
            f = new File(f, TEST_PREFIX);
            Assert.assertTrue((boolean)f.mkdir());
            pathsRetainer.root = dir;
            dir = f.toPath();
        } else {
            pathsRetainer.root = dir;
        }
        Path file = Files.createTempFile(dir, FILE_NAME_LEVEL_0, ".txt", attribs);
        pathsRetainer.rootFile = file;
        this.writeGibberish(file);
        Path subdir = Files.createTempDirectory(dir, DIR_SUB, new FileAttribute[0]);
        pathsRetainer.sub = subdir;
        file = Files.createTempFile(subdir, FILE_NAME_LEVEL_1, ".txt", attribs);
        pathsRetainer.subFile = file;
        this.writeGibberish(file);
        return pathsRetainer;
    }

    private void writeGibberish(Path p) throws IOException {
        Files.write(p, GIBBERISH.getBytes(), new OpenOption[0]);
    }

    private static class PathsRetainer {
        private Path root;
        private Path rootFile;
        private Path sub;
        private Path subFile;

        private PathsRetainer() {
        }
    }
}

