/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.xnio.FutureResult;

public final class FrameChecker
implements WebSocketTestClient.FrameListener {
    private final Class<? extends WebSocketFrame> clazz;
    private final byte[] expectedPayload;
    private final FutureResult<?> latch;
    private volatile boolean first = true;

    public FrameChecker(Class<? extends WebSocketFrame> clazz, byte[] expectedPayload, FutureResult<?> latch) {
        this.clazz = clazz;
        this.expectedPayload = expectedPayload;
        this.latch = latch;
    }

    @Override
    public void onFrame(WebSocketFrame frame) {
        try {
            if (this.first) {
                this.first = false;
                Assert.assertTrue((boolean)this.clazz.isInstance(frame));
                if (frame instanceof TextWebSocketFrame) {
                    String buf = ((TextWebSocketFrame)frame).text();
                    Assert.assertEquals((Object)new String(this.expectedPayload, StandardCharsets.UTF_8), (Object)buf);
                } else {
                    ByteBuf buf = frame.content();
                    byte[] data = new byte[buf.readableBytes()];
                    buf.readBytes(data);
                    Assert.assertArrayEquals((byte[])this.expectedPayload, (byte[])data);
                }
                this.latch.setResult(null);
            } else {
                Assert.assertTrue((boolean)CloseWebSocketFrame.class.isInstance(frame));
            }
        }
        catch (Throwable e) {
            this.latch.setException(new IOException(e));
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            t.printStackTrace();
            Assert.fail();
        }
        finally {
            this.latch.setException(new IOException(t));
        }
    }
}

