/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.WriteTimeoutException;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class MultipleRequestsWriteTimeoutTestCase {
    private static final Logger log = Logger.getLogger(MultipleRequestsWriteTimeoutTestCase.class);
    private static final Integer WRITE_TIMEOUT_VALUE = 100;
    private IOException exception;
    private CountDownLatch transferComplete;

    @DefaultServer.BeforeServerStarts
    public static void setup() {
        DefaultServer.setServerOptions(OptionMap.builder().set(Options.WRITE_TIMEOUT, (Object)WRITE_TIMEOUT_VALUE).getMap());
    }

    @DefaultServer.AfterServerStops
    public static void cleanup() {
        DefaultServer.setServerOptions(OptionMap.EMPTY);
    }

    @Test
    public void testWriteTimeout() throws IOException, InterruptedException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                MultipleRequestsWriteTimeoutTestCase.this.transferComplete = new CountDownLatch(1);
                int contentLength = 8192;
                ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
                for (int i = 0; i < 8192; ++i) {
                    buffer.put((byte)42);
                }
                buffer.flip();
                exchange.getResponseHeaders().add(HttpString.tryFromString((String)"Content-Length"), 8192L);
                exchange.getResponseSender().send(buffer, new IoCallback(){

                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        MultipleRequestsWriteTimeoutTestCase.this.transferComplete.countDown();
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        log.errorf((Throwable)exception, "Exception thrown during writing response.", new Object[0]);
                        MultipleRequestsWriteTimeoutTestCase.this.exception = exception;
                        MultipleRequestsWriteTimeoutTestCase.this.transferComplete.countDown();
                    }
                });
            }
        });
        try (PoolingHttpClientConnectionManager basicConnManager = new PoolingHttpClientConnectionManager();
             CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)basicConnManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).build();){
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.setHeader("Keep-Alive", "timeout=5");
            log.infof("Request 1", new Object[0]);
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            this.readContent(response);
            Thread.sleep((long)WRITE_TIMEOUT_VALUE.intValue() * 3L);
            log.infof("Request 2", new Object[0]);
            response = client.execute((HttpUriRequest)get);
            this.readContent(response);
        }
        this.assertSuccess();
    }

    @Test
    public void testWriteTimeoutOnEjbLikeRequests() throws IOException, InterruptedException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                MultipleRequestsWriteTimeoutTestCase.this.transferComplete = new CountDownLatch(1);
                int capacity = 1024;
                ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
                for (int i = 0; i < 1024; ++i) {
                    buffer.put((byte)42);
                }
                buffer.flip();
                StreamSinkChannel responseChannel = exchange.getResponseChannel();
                responseChannel.getWriteSetter().set(channel -> {
                    try {
                        channel.write(buffer.duplicate());
                        channel.flush();
                        channel.suspendWrites();
                        Thread.sleep((long)WRITE_TIMEOUT_VALUE.intValue() * 3L);
                        channel.write(buffer.duplicate());
                        channel.flush();
                        channel.suspendWrites();
                        exchange.endExchange();
                    }
                    catch (IOException e) {
                        MultipleRequestsWriteTimeoutTestCase.this.exception = e;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        MultipleRequestsWriteTimeoutTestCase.this.transferComplete.countDown();
                    }
                });
                responseChannel.resumeWrites();
            }
        });
        try (PoolingHttpClientConnectionManager basicConnManager = new PoolingHttpClientConnectionManager();
             CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)basicConnManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).build();){
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            this.readContent(response);
        }
        this.assertSuccess();
    }

    private void readContent(CloseableHttpResponse response) {
        byte[] buffer = new byte[512];
        try {
            int read;
            InputStream content = response.getEntity().getContent();
            while ((read = content.read(buffer)) > 0) {
                log.debugf("Read %d bytes", read);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private void assertSuccess() throws IOException, InterruptedException {
        boolean latchValue = this.transferComplete.await(2L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Server writing didn't finish.", (boolean)latchValue);
        if (this.exception instanceof ClosedChannelException || this.exception instanceof WriteTimeoutException) {
            Assert.fail((String)"The connection timed out, while it shouldn't have.");
        } else if (this.exception != null) {
            throw this.exception;
        }
    }
}

