/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.CompletionLatchHandler;
import io.undertow.util.FileUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
public class AccessLogFileWithUnescapedCharactersTestCase {
    private static final Path logDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "logs");
    private static final int NUM_THREADS = 10;
    private static final int NUM_REQUESTS = 12;
    private static final HttpHandler HELLO_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send("Hello");
        }
    };

    @Before
    public void before() throws IOException {
        Files.createDirectories(logDirectory, new FileAttribute[0]);
    }

    @After
    public void after() throws IOException {
        FileUtils.deleteRecursive((Path)logDirectory);
    }

    @Test
    public void testSingleLogMessageToFile() throws IOException, InterruptedException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("server1.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server1.");
        this.verifySingleLogMessageToFile(logFileName, logReceiver);
    }

    @Test
    public void testSingleLogMessageToFileWithSuffix() throws IOException, InterruptedException {
        Path directory = logDirectory;
        Path logFileName = directory.resolve("server1.logsuffix");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server1.", "logsuffix");
        this.verifySingleLogMessageToFile(logFileName, logReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySingleLogMessageToFile(Path logFileName, DefaultAccessLogReceiver logReceiver) throws IOException, InterruptedException {
        CompletionLatchHandler latchHandler = new CompletionLatchHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "%h \"%r\" %s %b", AccessLogFileWithUnescapedCharactersTestCase.class.getClassLoader()));
        DefaultServer.setRootHandler(latchHandler);
        DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true));
        DefaultServer.setServerOptions(OptionMap.create((Option)UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/helloworld/\ud55c\uae00\uc774\ub984_test.html?param=\ud55c\uae00\uc774\ub984_ahoy");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse((HttpResponse)result));
            latchHandler.await();
            logReceiver.awaitWrittenForTest();
            String written = new String(Files.readAllBytes(logFileName), StandardCharsets.UTF_8);
            String protocolVersion = DefaultServer.isH2() ? "HTTP/2.0" : result.getProtocolVersion().toString();
            Assert.assertEquals((Object)(DefaultServer.getDefaultServerAddress().getAddress().getHostAddress() + " \"GET /helloworld/\ud55c\uae00\uc774\ub984_test.html?param=\ud55c\uae00\uc774\ub984_ahoy " + protocolVersion + "\" 200 5" + System.lineSeparator()), (Object)written);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

