/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.StopServerWithExternalWorkerUtils;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.util.WorkerUtils;
import io.undertow.websockets.core.UTF8Output;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class Http2WindowUpdateTimeoutTestCase {
    private static final String message = "01234567";
    public static final String MESSAGE = "/message";
    private static final int TEST_WRITE_TIMEOUT = 5000;
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static final AttachmentKey<IOException> RESPONSE_EXCEPTION = AttachmentKey.create(IOException.class);
    private static final OptionMap DEFAULT_OPTIONS;
    private static XnioWorker worker;
    private static Undertow server;
    private static URL ADDRESS;

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        int port = DefaultServer.getHostPort("default");
        final PathHandler path = new PathHandler().addExactPath(MESSAGE, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                boolean blocking = Boolean.parseBoolean((String)((Deque)exchange.getQueryParameters().get("blocking")).getFirst());
                final int size = Integer.parseUnsignedInt((String)((Deque)exchange.getQueryParameters().get("size")).getFirst());
                if (blocking && exchange.isInIoThread()) {
                    exchange.startBlocking();
                    exchange.dispatch((HttpHandler)this);
                    return;
                }
                exchange.setStatusCode(200);
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, (long)size);
                Sender sender = exchange.getResponseSender();
                sender.send(Http2WindowUpdateTimeoutTestCase.message, new IoCallback(){
                    int remaining;
                    {
                        this.remaining = size - Http2WindowUpdateTimeoutTestCase.message.length();
                    }

                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        int toWrite = this.remaining > Http2WindowUpdateTimeoutTestCase.message.length() ? Http2WindowUpdateTimeoutTestCase.message.length() : this.remaining;
                        this.remaining -= toWrite;
                        if (!exchange.isComplete()) {
                            if (this.remaining > 0) {
                                sender.send(Http2WindowUpdateTimeoutTestCase.message, (IoCallback)this);
                            } else {
                                sender.send(Http2WindowUpdateTimeoutTestCase.message.substring(0, toWrite));
                            }
                        } else {
                            sender.close();
                        }
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        IoCallback.END_EXCHANGE.onException(exchange, sender, exception);
                    }
                });
            }
        });
        server = Undertow.builder().setByteBufferPool(DefaultServer.getBufferPool()).addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.WRITE_TIMEOUT, (Object)5000).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!exchange.getProtocol().equals(Protocols.HTTP_2_0)) {
                    throw new RuntimeException("Not HTTP/2");
                }
                path.handleRequest(exchange);
            }
        }).build();
        server.start();
        ADDRESS = new URL("https://" + DefaultServer.getHostAddress() + ":" + (port + 1));
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        if (server != null) {
            server.stop();
        }
        if (worker != null) {
            StopServerWithExternalWorkerUtils.stopWorker(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(boolean blocking, int size, int timeout, boolean repetitiveTimeout, boolean expectedTimedout) throws Exception {
        Assert.assertTrue((String)("Size should be greater than " + message.length()), (size >= message.length() ? 1 : 0) != 0);
        UndertowClient client = UndertowClient.getInstance();
        ClientConnection connection = (ClientConnection)client.connect(ADDRESS.toURI(), worker, (XnioSsl)new UndertowXnioSsl(worker.getXnio(), OptionMap.EMPTY, DefaultServer.getClientSSLContext()), DefaultServer.getBufferPool(), OptionMap.builder().set(UndertowOptions.ENABLE_HTTP2, true).set(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE, 2048).getMap()).get();
        CopyOnWriteArrayList responses = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/message?blocking=" + blocking + "&size=" + size);
                request.getRequestHeaders().put(Headers.HOST, DefaultServer.getHostAddress());
                connection.sendRequest(request, this.createClientCallback(timeout, repetitiveTimeout, responses, latch));
            });
            Assert.assertTrue((String)"Response did not come in the specified time", (boolean)latch.await(20000L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((String)"Incorrect number of responses returned", (long)1L, (long)responses.size());
            ClientResponse response = (ClientResponse)responses.iterator().next();
            Assert.assertEquals((String)"Incorrect status code", (long)200L, (long)response.getResponseCode());
            IOException exception = (IOException)response.getAttachment(RESPONSE_EXCEPTION);
            String body = (String)response.getAttachment(RESPONSE_BODY);
            if (expectedTimedout) {
                Assert.assertNull((String)"Body was returned when timeout was expected", (Object)body);
                Assert.assertNotNull((String)"Exception not present when timeout was expected", (Object)exception);
                Assert.assertTrue((String)"The exception is not a reset", (boolean)exception.getMessage().contains("Http2 stream was reset"));
            } else {
                Assert.assertNull((String)"Exception was returned when timeout was not expected", (Object)exception);
                Assert.assertNotNull((String)"Body not present when timeout was not expected", (Object)body);
                Assert.assertEquals((String)"Incorrect reponse size", (long)size, (long)body.length());
                for (int i = 0; i < body.length(); i += message.length()) {
                    Assert.assertEquals((String)("Incorect response at position=" + i), (Object)message.substring(0, i + message.length() > body.length() ? body.length() % message.length() : message.length()), (Object)body.substring(i, i + message.length() > body.length() ? body.length() : i + message.length()));
                }
            }
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
    }

    @Test
    public void testBlockingSuccess() throws Exception {
        this.test(true, DefaultServer.getBufferPool().getBufferSize() * 4, 100, false, false);
    }

    @Test
    public void testNonBlockingSuccess() throws Exception {
        this.test(false, DefaultServer.getBufferPool().getBufferSize() * 4, 100, false, false);
    }

    @Test
    public void testBlockingTimeout() throws Exception {
        this.test(true, DefaultServer.getBufferPool().getBufferSize() * 4, 10000, false, true);
    }

    @Test
    public void testNonBlockingTimeout() throws Exception {
        this.test(true, DefaultServer.getBufferPool().getBufferSize() * 4, 10000, false, true);
    }

    @Test
    public void testBlockingTimeoutRepetitive() throws Exception {
        this.test(true, DefaultServer.getBufferPool().getBufferSize() * 4, 500, true, false);
    }

    @Test
    public void testNonBlockingRepetitive() throws Exception {
        this.test(false, DefaultServer.getBufferPool().getBufferSize() * 4, 500, true, false);
    }

    private ClientCallback<ClientExchange> createClientCallback(final int timeout, final boolean repetitiveTimeout, final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(final ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(ClientExchange result2) {
                        responses.add(result2.getResponse());
                        result2.getResponseChannel().suspendReads();
                        ReadChannelListener listener = new ReadChannelListener(result2, latch, repetitiveTimeout ? timeout : -1);
                        result2.getResponseChannel().getReadSetter().set((ChannelListener)listener);
                        if (timeout > 0) {
                            WorkerUtils.executeAfter((XnioIoThread)result2.getResponseChannel().getIoThread(), (Runnable)listener, (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                        } else {
                            listener.run();
                        }
                    }

                    public void failed(IOException e) {
                        e.printStackTrace();
                        result.getResponse().putAttachment(RESPONSE_EXCEPTION, (Object)e);
                        latch.countDown();
                    }
                });
            }

            public void failed(IOException e) {
                e.printStackTrace();
                latch.countDown();
            }
        };
    }

    static {
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
    }

    public static class ReadChannelListener
    implements ChannelListener<StreamSourceChannel>,
    Runnable {
        private final ClientExchange result;
        private final UTF8Output string = new UTF8Output();
        private final CountDownLatch latch;
        private final int timeout;

        public ReadChannelListener(ClientExchange result, CountDownLatch latch, int timeout) {
            this.result = result;
            this.latch = latch;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(StreamSourceChannel channel) {
            PooledByteBuffer resource = this.result.getConnection().getBufferPool().allocate();
            ByteBuffer buffer = resource.getBuffer();
            try {
                int r;
                block11: do {
                    r = channel.read(buffer);
                    switch (r) {
                        case 0: {
                            if (this.timeout > 0) {
                                channel.suspendReads();
                                WorkerUtils.executeAfter((XnioIoThread)this.result.getResponseChannel().getIoThread(), (Runnable)this, (long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                            } else if (!channel.isReadResumed()) {
                                channel.resumeReads();
                            }
                            return;
                        }
                        case -1: {
                            this.result.getResponse().putAttachment(RESPONSE_BODY, (Object)this.string.extract());
                            IoUtils.safeClose((Closeable)channel);
                            this.latch.countDown();
                            break;
                        }
                        default: {
                            buffer.flip();
                            this.string.write(new ByteBuffer[]{buffer});
                            if (this.timeout <= 0) continue block11;
                            channel.suspendReads();
                            WorkerUtils.executeAfter((XnioIoThread)this.result.getResponseChannel().getIoThread(), (Runnable)this, (long)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                            return;
                        }
                    }
                } while (r > 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.result.getResponse().putAttachment(RESPONSE_EXCEPTION, (Object)e);
                this.latch.countDown();
            }
            finally {
                resource.close();
            }
        }

        @Override
        public void run() {
            this.handleEvent(this.result.getResponseChannel());
        }
    }
}

