/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.IPv6Ignore;
import io.undertow.testutils.IPv6Only;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class IPAddressAccessControlHandlerWithProxyPeerAddressHandlerTestCase {
    @BeforeClass
    public static void setup() {
        HttpHandler rootHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
                exchange.getResponseSender().send(exchange.getSourceAddress().getHostString());
            }
        };
        rootHandler = DefaultServer.isIpv6() ? Handlers.ipAccessControl((HttpHandler)rootHandler, (boolean)false).addAllow("::1") : Handlers.ipAccessControl((HttpHandler)rootHandler, (boolean)false).addAllow("127.0.0.0/8");
        DefaultServer.setRootHandler((HttpHandler)Handlers.proxyPeerAddress((HttpHandler)rootHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testWithoutXForwardedFor() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("127.0.0.1"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Only
    public void testWithoutXForwardedForIPv6() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("0:0:0:0:0:0:0:1"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testWithXForwardedFor1() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.addHeader("X-Forwarded-For", "127.0.0.2");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("127.0.0.2"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testWithXForwardedFor2() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.addHeader("X-Forwarded-For", "127.0.0.1, 192.168.0.10");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("127.0.0.1"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testWithXForwardedFor3() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.addHeader("X-Forwarded-For", "127.0.0.1, 127.0.0.2, 192.168.0.10");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.contains("127.0.0.1"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testForbiddenWithXForwardedFor1() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.addHeader("X-Forwarded-For", "192.168.0.10");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.isEmpty());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @IPv6Ignore
    public void testForbiddenWithXForwardedFor2() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
            get.addHeader("X-Forwarded-For", "192.168.0.10, 192.168.0.20");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((boolean)response.isEmpty());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

