/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.builder;

import io.undertow.predicate.ContainsPredicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.RequestDumpingHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.testutils.category.UnitTest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class PredicatedHandlersParserTestCase {
    @Test
    public void testAstRepresentation1() {
        String value = "path(/foo) -> rewrite(/bar)";
        PredicatedHandlersParser.Node node = PredicatedHandlersParser.parse((String)value, (Deque)PredicatedHandlersParser.tokenize((String)value));
        Assert.assertTrue((boolean)(node instanceof PredicatedHandlersParser.PredicateOperatorNode));
        PredicatedHandlersParser.PredicateOperatorNode op = (PredicatedHandlersParser.PredicateOperatorNode)node;
        Assert.assertEquals((Object)"->", (Object)op.getToken().getToken());
        Assert.assertEquals((Object)"path", (Object)op.getLeft().getToken().getToken());
        Assert.assertEquals((Object)"/foo", (Object)((PredicatedHandlersParser.Node)((PredicatedHandlersParser.ExpressionNode)op.getLeft()).getValues().get(null)).toString());
    }

    @Test
    public void testAstRepresentation2() {
        String value = "path(/foo) -> rewrite(/bar)\npath(/foo) -> rewrite(/bar)";
        PredicatedHandlersParser.Node node = PredicatedHandlersParser.parse((String)value, (Deque)PredicatedHandlersParser.tokenize((String)value));
        Assert.assertTrue((boolean)(node instanceof PredicatedHandlersParser.BlockNode));
        PredicatedHandlersParser.BlockNode block = (PredicatedHandlersParser.BlockNode)node;
        PredicatedHandlersParser.PredicateOperatorNode op = (PredicatedHandlersParser.PredicateOperatorNode)block.getBlock().get(1);
        Assert.assertEquals((Object)"->", (Object)op.getToken().getToken());
        Assert.assertEquals((Object)"path", (Object)op.getLeft().getToken().getToken());
        Assert.assertEquals((Object)"/foo", (Object)((PredicatedHandlersParser.Node)((PredicatedHandlersParser.ExpressionNode)op.getLeft()).getValues().get(null)).toString());
    }

    @Test
    public void testAstRepresentation3() {
        String value = "path(/foo) -> { rewrite(/bar); path(/x) -> rewrite(/x)}";
        PredicatedHandlersParser.Node node = PredicatedHandlersParser.parse((String)value, (Deque)PredicatedHandlersParser.tokenize((String)value));
        Assert.assertTrue((boolean)(node instanceof PredicatedHandlersParser.PredicateOperatorNode));
        PredicatedHandlersParser.PredicateOperatorNode op = (PredicatedHandlersParser.PredicateOperatorNode)node;
        Assert.assertEquals((Object)"->", (Object)op.getToken().getToken());
        Assert.assertEquals((Object)"path", (Object)op.getLeft().getToken().getToken());
        Assert.assertEquals((Object)"/foo", (Object)((PredicatedHandlersParser.Node)((PredicatedHandlersParser.ExpressionNode)op.getLeft()).getValues().get(null)).toString());
        PredicatedHandlersParser.BlockNode block = (PredicatedHandlersParser.BlockNode)op.getRight();
        op = (PredicatedHandlersParser.PredicateOperatorNode)block.getBlock().get(1);
        Assert.assertEquals((Object)"->", (Object)op.getToken().getToken());
        Assert.assertEquals((Object)"path", (Object)op.getLeft().getToken().getToken());
        Assert.assertEquals((Object)"/x", (Object)((PredicatedHandlersParser.Node)((PredicatedHandlersParser.ExpressionNode)op.getLeft()).getValues().get(null)).toString());
    }

    @Test
    public void testParsedHandler1() {
        String value = "dump-request";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        HttpHandler handler = ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertTrue((boolean)(handler instanceof RequestDumpingHandler));
    }

    @Test
    public void testParsedHandler2() {
        String value = "header(header=a, value='a%%lb')";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        SetHeaderHandler handler = (SetHeaderHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals((Object)"a", (Object)handler.getHeader().toString());
        Assert.assertEquals((Object)"a%lb", (Object)handler.getValue().readAttribute(null));
    }

    @Test
    public void testParsedHandler3() {
        String value = "allowed-methods(GET)";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        AllowedMethodsHandler handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods(methods=GET)";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods(methods={GET})";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods({GET})";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods({GET, POST})";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"), HttpString.tryFromString((String)"POST"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods(methods={GET, POST})";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"), HttpString.tryFromString((String)"POST"))), (Object)handler.getAllowedMethods());
        value = "allowed-methods(GET, POST)";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = (AllowedMethodsHandler)((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertEquals(new HashSet<HttpString>(Arrays.asList(HttpString.tryFromString((String)"GET"), HttpString.tryFromString((String)"POST"))), (Object)handler.getAllowedMethods());
    }

    @Test
    public void testParsedPredicatedHandler1() {
        String value = "contains(value='a', search=b) -> dump-request";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        HttpHandler handler = ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertTrue((boolean)(handler instanceof RequestDumpingHandler));
        ContainsPredicate predicate = (ContainsPredicate)((PredicatedHandler)ret.get(0)).getPredicate();
        Assert.assertEquals((Object)"a", (Object)predicate.getAttribute().readAttribute(null));
        Assert.assertArrayEquals((Object[])new String[]{"b"}, (Object[])predicate.getValues());
        value = "contains(value='a', search={b}) -> dump-request";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertTrue((boolean)(handler instanceof RequestDumpingHandler));
        predicate = (ContainsPredicate)((PredicatedHandler)ret.get(0)).getPredicate();
        Assert.assertEquals((Object)"a", (Object)predicate.getAttribute().readAttribute(null));
        Assert.assertArrayEquals((Object[])new String[]{"b"}, (Object[])predicate.getValues());
        value = "contains[value='a', search={b, c}] -> dump-request";
        ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        handler = ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200);
        Assert.assertTrue((boolean)(handler instanceof RequestDumpingHandler));
        predicate = (ContainsPredicate)((PredicatedHandler)ret.get(0)).getPredicate();
        Assert.assertEquals((Object)"a", (Object)predicate.getAttribute().readAttribute(null));
        Assert.assertArrayEquals((Object[])new String[]{"b", "c"}, (Object[])predicate.getValues());
    }

    @Test
    public void testClearHeader() throws Exception {
        String value = "set(attribute=%{i,User-Agent}, value=%{NULL})";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        HttpServerExchange exchange = new HttpServerExchange(null);
        exchange.getRequestHeaders().put(Headers.USER_AGENT, "firefox");
        ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200).handleRequest(exchange);
        Assert.assertNull((Object)exchange.getRequestHeaders().get(Headers.USER_AGENT));
    }

    @Test
    public void testEmptyHeader() throws Exception {
        String value = "set(attribute=%{i,User-Agent}, value='')";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        HttpServerExchange exchange = new HttpServerExchange(null);
        exchange.getRequestHeaders().put(Headers.USER_AGENT, "firefox");
        ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200).handleRequest(exchange);
        Assert.assertNotNull((Object)exchange.getRequestHeaders().get(Headers.USER_AGENT));
        Assert.assertEquals((long)1L, (long)exchange.getRequestHeaders().get(Headers.USER_AGENT).size());
        Assert.assertEquals((Object)"", (Object)exchange.getRequestHeaders().get(Headers.USER_AGENT).getFirst());
    }

    @Test
    public void testEscapedQuote() throws Exception {
        String value = "set(attribute=%{i,User-Agent}, value='some\\'value')";
        List ret = PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)ret.size());
        HttpServerExchange exchange = new HttpServerExchange(null);
        exchange.getRequestHeaders().put(Headers.USER_AGENT, "firefox");
        ((PredicatedHandler)ret.get(0)).getHandler().wrap((HttpHandler)ResponseCodeHandler.HANDLE_200).handleRequest(exchange);
        Assert.assertNotNull((Object)exchange.getRequestHeaders().get(Headers.USER_AGENT));
        Assert.assertEquals((long)1L, (long)exchange.getRequestHeaders().get(Headers.USER_AGENT).size());
        Assert.assertEquals((Object)"some'value", (Object)exchange.getRequestHeaders().get(Headers.USER_AGENT).getFirst());
    }

    @Test
    public void testMissingRequiredHandlerParameter() throws Exception {
        String value = "set(attribute=%{i,User-Agent})";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"required parameters [value] not provided for handler set"));
    }

    @Test
    public void testMissingRequiredPredicateParameter() throws Exception {
        String value = "contains(value=a) -> dump-request";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PredicatedHandlersParser.parse((String)value, (ClassLoader)this.getClass().getClassLoader()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.containsString((String)"required parameters [search] not provided for predicate contains"));
    }
}

