/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.Undertow;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.xnio.XnioWorker;

public class StopServerWithExternalWorkerUtils {
    private StopServerWithExternalWorkerUtils() {
    }

    public static void stopServerAndWorker(Undertow server) {
        XnioWorker worker = server.getWorker();
        server.stop();
        StopServerWithExternalWorkerUtils.stopWorker(worker);
    }

    public static void stopWorker(XnioWorker worker) {
        worker.shutdown();
        try {
            if (!worker.awaitTermination(10L, TimeUnit.SECONDS)) {
                List tasks = worker.shutdownNow();
                for (Runnable task : tasks) {
                    task.run();
                }
                if (!worker.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Worker failed to shutdown within ten seconds");
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static void stopServer(Undertow server) {
        XnioWorker worker = server.getWorker();
        server.stop();
        StopServerWithExternalWorkerUtils.waitWorkerRunnableCycle(worker);
    }

    public static void waitWorkerRunnableCycle(XnioWorker worker) {
        CountDownLatch serverShutdownLatch = new CountDownLatch(1);
        worker.getIoThread().execute(serverShutdownLatch::countDown);
        try {
            serverShutdownLatch.await();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

