/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.ByteRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class ByteRangeTestCase {
    @Test
    public void testGetRanges() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(3L, 5L), new ByteRange.Range(4L, 8L), new ByteRange.Range(3L, 9L))));
        Assert.assertEquals((long)3L, (long)byteRange.getRanges());
    }

    @Test
    public void testGetStart() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(3L, 5L), new ByteRange.Range(4L, 8L), new ByteRange.Range(3L, 9L))));
        Assert.assertEquals((long)3L, (long)byteRange.getStart(0));
        Assert.assertEquals((long)4L, (long)byteRange.getStart(1));
        Assert.assertEquals((long)3L, (long)byteRange.getStart(2));
    }

    @Test
    public void testGetEnd() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(3L, 5L), new ByteRange.Range(4L, 8L), new ByteRange.Range(3L, 9L))));
        Assert.assertEquals((long)5L, (long)byteRange.getEnd(0));
        Assert.assertEquals((long)8L, (long)byteRange.getEnd(1));
        Assert.assertEquals((long)9L, (long)byteRange.getEnd(2));
    }

    @Test
    public void testParse() {
        Assert.assertNull((Object)ByteRange.parse(null));
        Assert.assertNull((Object)ByteRange.parse((String)"foo"));
        Assert.assertNull((Object)ByteRange.parse((String)"bytes=1"));
        Assert.assertNull((Object)ByteRange.parse((String)"bytes=a-"));
        Assert.assertNull((Object)ByteRange.parse((String)"foobarbaz"));
        Assert.assertNull((Object)ByteRange.parse((String)"bytes=--1"));
        Assert.assertEquals((long)1L, (long)ByteRange.parse((String)"bytes=2-").getRanges());
        Assert.assertEquals((long)1L, (long)ByteRange.parse((String)"bytes=-20").getRanges());
    }

    @Test
    public void testGetResponseResult1() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(3L, 5L), new ByteRange.Range(4L, 8L), new ByteRange.Range(3L, 9L))));
        Assert.assertNull((Object)byteRange.getResponseResult(0L, "\"1\"", new Date(1559820153000L), "foo"));
        Assert.assertNull((Object)byteRange.getResponseResult(0L, "Mon, 31 Mar 2014 09:24:49 GMT", new Date(1559820153000L), "foo"));
    }

    @Test
    public void testGetResponseResult2() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(-1L, -1L))));
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes */0", (Object)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)416L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStatusCode());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes */6", (Object)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)416L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStatusCode());
    }

    @Test
    public void testGetResponseResult3() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(5L, -1L))));
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes */0", (Object)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)416L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStatusCode());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)1L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes 5-5/6", (Object)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)206L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStatusCode());
    }

    @Test
    public void testGetResponseResult4() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(0L, -1L))));
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes */0", (Object)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)416L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStatusCode());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)6L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes 0-5/6", (Object)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)206L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStatusCode());
    }

    @Test
    public void testGetResponseResult5() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(3L, 5L))));
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes */0", (Object)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)416L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStatusCode());
        Assert.assertEquals((long)3L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)3L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes 3-5/6", (Object)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)206L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStatusCode());
    }

    @Test
    public void testGetResponseResult6() {
        ByteRange byteRange = new ByteRange(new ArrayList<ByteRange.Range>(Arrays.asList(new ByteRange.Range(-1L, 5L))));
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)-1L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)0L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes 0--1/0", (Object)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)206L, (long)byteRange.getResponseResult(0L, null, new Date(1559820153000L), "foo").getStatusCode());
        Assert.assertEquals((long)1L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStart());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getEnd());
        Assert.assertEquals((long)5L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentLength());
        Assert.assertEquals((Object)"bytes 1-5/6", (Object)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getContentRange());
        Assert.assertEquals((long)206L, (long)byteRange.getResponseResult(6L, null, new Date(1559820153000L), "foo").getStatusCode());
    }

    @Test
    public void testGetResponseResultNull() {
        ByteRange byteRange = new ByteRange(new ArrayList());
        Assert.assertNull((Object)byteRange.getResponseResult(0L, "1", new Date(1559820153000L), "foo"));
    }
}

