/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.ssl;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;

public class DelegatedTaskExecutorTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegatedTaskExecutorIsUsed() throws Exception {
        ExecutorService delegatedTaskExecutor = Executors.newSingleThreadExecutor();
        AtomicInteger counter = new AtomicInteger();
        Undertow undertow = Undertow.builder().addHttpsListener(0, null, DefaultServer.getServerSslContext()).setSslEngineDelegatedTaskExecutor(task -> {
            counter.getAndIncrement();
            delegatedTaskExecutor.execute(task);
        }).setHandler((HttpHandler)ResponseCodeHandler.HANDLE_200).build();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        undertow.start();
        int port = DelegatedTaskExecutorTestCase.port(undertow);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet("https://localhost:" + port));){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertTrue((String)"expected interactions with the delegated task executor", (counter.get() > 0 ? 1 : 0) != 0);
        }
        finally {
            undertow.stop();
            client.getConnectionManager().shutdown();
            delegatedTaskExecutor.shutdownNow();
            Assert.assertTrue((String)"ExecutorService did not shut down in time", (boolean)delegatedTaskExecutor.awaitTermination(1L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRejection() {
        Undertow undertow = Undertow.builder().addHttpsListener(0, null, DefaultServer.getServerSslContext()).setSslEngineDelegatedTaskExecutor(ignoredTask -> {
            throw new RejectedExecutionException();
        }).setHandler((HttpHandler)ResponseCodeHandler.HANDLE_200).build();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        undertow.start();
        try {
            int port = DelegatedTaskExecutorTestCase.port(undertow);
            HttpGet request = new HttpGet("https://localhost:" + port);
            try {
                client.execute((HttpUriRequest)request);
                Assert.fail((String)"Expected an exception");
            }
            catch (SSLHandshakeException handshakeException) {
                String message = handshakeException.getMessage();
                System.out.println(message);
                Assert.assertTrue((String)("message was: " + message), (message != null && (message.contains("closed") || message.contains("terminated")) ? 1 : 0) != 0);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        finally {
            undertow.stop();
            client.getConnectionManager().shutdown();
        }
    }

    private static int port(Undertow undertow) {
        if (undertow.getListenerInfo().size() != 1) {
            throw new IllegalStateException("Expected exactly one listener");
        }
        InetSocketAddress address = (InetSocketAddress)((Undertow.ListenerInfo)undertow.getListenerInfo().get(0)).getAddress();
        return address.getPort();
    }
}

