/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.proxy;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.FileUtils;
import io.undertow.util.HttpString;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class ProxyProtocolTestCase {
    private static final byte[] SIG = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final byte[] NAME = "PROXY ".getBytes(StandardCharsets.US_ASCII);
    private static final byte PROXY = 33;
    private static final byte LOCAL = 32;
    private static final byte TCPv4 = 17;
    private static final byte TCPv6 = 33;
    private Undertow undertow = Undertow.builder().addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.HTTP).setHost(DefaultServer.getHostAddress()).setUseProxyProtocol(true).setPort(0)).setHandler(new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.setPersistent(false);
            exchange.getResponseHeaders().put(new HttpString("result"), exchange.getSourceAddress().toString().replace("[", "").replace("]", "") + " " + exchange.getDestinationAddress().toString().replace("[", "").replace("]", ""));
        }
    }).build();
    private Undertow undertowSsl = Undertow.builder().addListener(new Undertow.ListenerBuilder().setType(Undertow.ListenerType.HTTPS).setSslContext(DefaultServer.getServerSslContext()).setHost(DefaultServer.getHostAddress()).setUseProxyProtocol(true).setPort(0)).setHandler(new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.setPersistent(false);
            exchange.getResponseHeaders().put(new HttpString("result"), exchange.getSourceAddress().toString() + " " + exchange.getDestinationAddress().toString());
        }
    }).build();

    @Test
    public void testProxyProtocolTcp4() throws Exception {
        String request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 0 65535\r\nGET / HTTP/1.0\r\n\r\n";
        expectedResponse = "result: /1.2.3.4:0 /5.6.7.8:65535";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
    }

    @Test
    public void testProxyProtocolTcp4Negative() throws Exception {
        String request = "PROXY  TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4  1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4  5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8  444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444  555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\rGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 001.002.003.004 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 111444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 111555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 -444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 005.006.007.008 444 -555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 0444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 0555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 277.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 1.2.3.4 5d.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY, TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP4 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    @Test
    public void testProxyProtocolTcp6() throws Exception {
        String request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:444 /fe80:0:0:0:5ec5:d4ff:fede:66d8:555";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 0 65535\r\nGET / HTTP/1.0\r\n\r\n";
        expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:0 /fe80:0:0:0:5ec5:d4ff:fede:66d8:65535";
        this.proxyProtocolRequestResponseCheck(request, expectedResponse);
    }

    @Test
    public void testProxyProtocolTcp6Negative() throws Exception {
        String request = "PROXY  TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6  fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc  fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8  444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444  555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\rGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fz80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5zc5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 111444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 111555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 -444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 -555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 0444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 0555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY, TCP6 fe80::56ee:75ff:fe44:85bc fe80::5ec5:d4ff:fede:66d8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY TCP6 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    @Test
    public void testProxyProtocolNegative() throws Exception {
        String request = "NONSENSE\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "NONSENSE TCP4 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "NONSENSE\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY NONSENSE\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
        request = "PROXY NONSENSE 1.2.3.4 5.6.7.8 444 555\r\nGET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyProtocolRequestResponseCheck(String request, String expectedResponse) throws Exception {
        try {
            this.undertow.start();
            int port = ((InetSocketAddress)((Undertow.ListenerInfo)this.undertow.getListenerInfo().get(0)).getAddress()).getPort();
            Socket s = new Socket(DefaultServer.getHostAddress(), port);
            s.getOutputStream().write(request.getBytes(StandardCharsets.US_ASCII));
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expectedResponse));
        }
        finally {
            this.undertow.stop();
        }
    }

    @Test
    public void testProxyProtocolSSl() throws Exception {
        String request = "PROXY TCP4 1.2.3.4 5.6.7.8 444 555\r\n";
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, expectedResponse);
        request = "PROXY TCP4  1.2.3.4 5.6.7.8 444 555\r\n";
        requestHttp = "GET / HTTP/1.0\r\n\r\n";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
    }

    @Test
    public void testProxyProtocolV2Tcp4() throws Exception {
        byte[] header = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 12, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, 555);
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(header, requestHttp, expectedResponse);
        header = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 12, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 0, 65535);
        expectedResponse = "result: /1.2.3.4:0 /5.6.7.8:65535";
        this.proxyProtocolRequestResponseCheck(header, requestHttp, expectedResponse);
        header = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 100, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, 555);
        expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(header, requestHttp, expectedResponse);
    }

    @Test
    public void testProxyProtocolV2SSl() throws Exception {
        byte[] header = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 12, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, 555);
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        String expectedResponse = "result: /1.2.3.4:444 /5.6.7.8:555";
        this.proxyProtocolRequestResponseCheck(header, requestHttp, expectedResponse);
    }

    @Test
    public void testProxyProtocolV2Tcp4Negative() throws Exception {
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        byte[] request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 10, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, null);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 8, InetAddress.getByName("1.2.3.4"), null, 444, 555);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)66, 12, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, 555);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)17, 4, InetAddress.getByName("1.2.3.4"), null, null, null);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
    }

    @Test
    public void testProxyProtocolV2Tcp6() throws Exception {
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        byte[] request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)33, 36, InetAddress.getByName("fe80::56ee:75ff:fe44:85bc"), InetAddress.getByName("fe80::5ec5:d4ff:fede:66d8"), 444, 555);
        String expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:444 /fe80:0:0:0:5ec5:d4ff:fede:66d8:555";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, expectedResponse);
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)33, 36, InetAddress.getByName("fe80::56ee:75ff:fe44:85bc"), InetAddress.getByName("fe80::5ec5:d4ff:fede:66d8"), 0, 65535);
        expectedResponse = "result: /fe80:0:0:0:56ee:75ff:fe44:85bc:0 /fe80:0:0:0:5ec5:d4ff:fede:66d8:65535";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, expectedResponse);
    }

    @Test
    public void testProxyProtocolV2Tcp6Negative() throws Exception {
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        byte[] request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)33, 34, InetAddress.getByName("fe80::56ee:75ff:fe44:85bc"), InetAddress.getByName("fe80::5ec5:d4ff:fede:66d8"), 444, null);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)33, 20, InetAddress.getByName("1.2.3.4"), null, 444, 555);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)66, 36, InetAddress.getByName("fe80::56ee:75ff:fe44:85bc"), InetAddress.getByName("fe80::5ec5:d4ff:fede:66d8"), 444, 555);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = ProxyProtocolTestCase.createProxyHeaderV2((byte)33, (byte)33, 16, InetAddress.getByName("fe80::56ee:75ff:fe44:85bc"), null, null, null);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
    }

    @Test
    public void testProxyProtocolV2Local() throws Exception {
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        byte[] request = ProxyProtocolTestCase.createProxyHeaderV2((byte)32, (byte)0, 0, null, null, null, null);
        String expectedResponse = ProxyProtocolTestCase.isIpV6() ? "result: /0:0:0:0:0:0:0:1" : "result: /127.0.0.1";
        this.proxyProtocolRequestResponseCheck(request, requestHttp, expectedResponse);
    }

    @Test
    public void testProxyProtocolV2Negative() throws Exception {
        String requestHttp = "GET / HTTP/1.0\r\n\r\n";
        byte[] request = ProxyProtocolTestCase.createProxyHeaderV2((byte)0, (byte)17, 12, InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8"), 444, 555);
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = new byte[]{NAME[0], 0, 0, 0};
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = new byte[]{SIG[0], 0, 0, 0};
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
        request = new byte[]{0, 0, 0, 0};
        this.proxyProtocolRequestResponseCheck(request, requestHttp, "");
    }

    private static byte[] createProxyHeaderV2(Byte ver_cmd, Byte family, Integer len, InetAddress sourceAddress, InetAddress destAddress, Integer sourcePort, Integer destPort) {
        ByteBuffer buffer = ByteBuffer.allocate(16 + len);
        buffer.put(SIG);
        if (ver_cmd != null) {
            buffer.put((byte)(ver_cmd & 0xFF));
        }
        if (family != null) {
            buffer.put((byte)(family & 0xFF));
        }
        if (len != null) {
            buffer.putShort((short)(len & 0xFFFF));
        }
        if (sourceAddress != null) {
            buffer.put(sourceAddress.getAddress());
        }
        if (destAddress != null) {
            buffer.put(destAddress.getAddress());
        }
        if (sourcePort != null) {
            buffer.putShort((short)(sourcePort & 0xFFFF));
        }
        if (destPort != null) {
            buffer.putShort((short)(destPort & 0xFFFF));
        }
        return buffer.array();
    }

    private void proxyProtocolRequestResponseCheck(String requestProxy, String requestHttp, String expectedResponse) throws Exception {
        this.proxyProtocolRequestResponseCheck(requestProxy.getBytes(StandardCharsets.US_ASCII), requestHttp, expectedResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyProtocolRequestResponseCheck(byte[] request, String requestHttp, String expectedResponse) throws Exception {
        try {
            this.undertow.start();
            int port = ((InetSocketAddress)((Undertow.ListenerInfo)this.undertow.getListenerInfo().get(0)).getAddress()).getPort();
            Socket s = new Socket(DefaultServer.getHostAddress(), port);
            s.getOutputStream().write(request);
            if (!expectedResponse.isEmpty()) {
                s.getOutputStream().write(requestHttp.getBytes(StandardCharsets.US_ASCII));
            }
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expectedResponse));
        }
        finally {
            this.undertow.stop();
        }
    }

    @Test
    public void testProxyProtocolUnknownEmpty() throws Exception {
        this.doTestProxyProtocolUnknown("");
    }

    @Test
    public void testProxyProtocolUnknownSpace() throws Exception {
        this.doTestProxyProtocolUnknown(" ");
    }

    @Test
    public void testProxyProtocolUnknownJunk() throws Exception {
        this.doTestProxyProtocolUnknown(" mekmitasdigoat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestProxyProtocolUnknown(String extra) throws Exception {
        try {
            this.undertow.start();
            InetSocketAddress serverAddress = (InetSocketAddress)((Undertow.ListenerInfo)this.undertow.getListenerInfo().get(0)).getAddress();
            Socket s = new Socket(serverAddress.getAddress(), serverAddress.getPort());
            String expected = String.format("result: /%s:%d /%s:%d", s.getLocalAddress().getHostAddress(), s.getLocalPort(), serverAddress.getAddress().getHostAddress(), serverAddress.getPort());
            s.getOutputStream().write(("PROXY UNKNOWN" + extra + "\r\nGET / HTTP/1.0\r\n\r\n").getBytes(StandardCharsets.US_ASCII));
            String result = FileUtils.readFile((InputStream)s.getInputStream());
            Assert.assertTrue((String)result, (boolean)result.contains(expected));
        }
        finally {
            this.undertow.stop();
        }
    }

    private static boolean isIpV6() {
        String preferIpV6Property = System.getProperty("java.net.preferIPv6Addresses");
        return preferIpV6Property != null && preferIpV6Property.toLowerCase().equals("true");
    }
}

