/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.SameThreadExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ChunkedRequestNotConsumedTestCase {
    private static final String MESSAGE = "My HTTP Request!";

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws InterruptedException {
                exchange.setResponseContentLength((long)"message".length());
                exchange.getResponseSender().send("message", new IoCallback(){

                    public void onComplete(final HttpServerExchange exchange, Sender sender) {
                        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

                            @Override
                            public void run() {
                                exchange.getIoThread().executeAfter(new Runnable(){

                                    @Override
                                    public void run() {
                                        exchange.endExchange();
                                    }
                                }, 300L, TimeUnit.MILLISECONDS);
                            }
                        });
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        exchange.endExchange();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChunkedRequestNotConsumed() throws IOException {
        HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            Random random = new Random();
            int seed = random.nextInt();
            System.out.print("Using Seed " + seed);
            random.setSeed(seed);
            for (int i = 0; i < 3; ++i) {
                post.setEntity((HttpEntity)new StringEntity(""){

                    public long getContentLength() {
                        return -1L;
                    }

                    public boolean isChunked() {
                        return true;
                    }

                    public void writeTo(OutputStream outstream) throws IOException {
                        outstream.flush();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        outstream.write(ChunkedRequestNotConsumedTestCase.MESSAGE.getBytes(StandardCharsets.US_ASCII));
                    }
                });
                CloseableHttpResponse result = client.execute((HttpUriRequest)post);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                HttpClientUtils.readResponse((HttpResponse)result);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

