/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class LoadBalancerConnectionPoolingTestCase {
    public static final int TTL = 2000;
    private static Undertow undertow;
    private static final Set<ServerConnection> activeConnections;
    static final String host;
    static int port;

    @BeforeClass
    public static void before() throws Exception {
        ProxyHandler proxyHandler = ProxyHandler.builder().setProxyClient((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).setSoftMaxConnectionsPerThread(0).setTtl(2000).setMaxQueueSize(1000).addHost(new URI("http", null, host, port, null, null, null), "s1")).setMaxRequestTime(10000).build();
        undertow = Undertow.builder().setIoThreads(1).addHttpListener(port + 1, host).setHandler((HttpHandler)proxyHandler).build();
        undertow.start();
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ServerConnection con = exchange.getConnection();
                if (!activeConnections.contains(con)) {
                    System.out.println("added " + con);
                    activeConnections.add(con);
                    con.addCloseListener(new ServerConnection.CloseListener(){

                        public void closed(ServerConnection connection) {
                            System.out.println("Closed " + connection);
                            activeConnections.remove(connection);
                        }
                    });
                }
            }
        });
    }

    @AfterClass
    public static void after() {
        undertow.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReduceConnectionPool() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        PoolingClientConnectionManager conman = new PoolingClientConnectionManager();
        conman.setDefaultMaxPerRoute(20);
        final TestHttpClient client = new TestHttpClient((ClientConnectionManager)conman);
        int requests = 20;
        final CountDownLatch latch = new CountDownLatch(requests);
        long ttlStartExpire = 2000L + System.currentTimeMillis();
        try {
            for (int i = 0; i < requests; ++i) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        HttpGet get = new HttpGet("http://" + host + ":" + (port + 1));
                        try {
                            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                            HttpClientUtils.readResponse((HttpResponse)response);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            if (!latch.await(2000L, TimeUnit.MILLISECONDS)) {
                Assert.fail();
            }
        }
        finally {
            client.getConnectionManager().shutdown();
            executorService.shutdown();
        }
        if (activeConnections.size() != 1 && System.currentTimeMillis() < ttlStartExpire) {
            Assert.fail((String)"there should still be a connection");
        }
        long end = System.currentTimeMillis() + 6000L;
        while (!activeConnections.isEmpty() && System.currentTimeMillis() < end) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)0L, (long)activeConnections.size());
    }

    static {
        activeConnections = Collections.newSetFromMap(new ConcurrentHashMap());
        host = DefaultServer.getHostAddress("default");
        port = DefaultServer.getHostPort("default");
    }
}

