/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.testutils.DefaultServer;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;

public class TestHttpClient
extends DefaultHttpClient {
    private static final X509HostnameVerifier NO_OP_VERIFIER = new X509HostnameVerifier(){

        public void verify(String host, SSLSocket ssl) throws IOException {
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };
    private static final List<TestHttpClient> instances = new CopyOnWriteArrayList<TestHttpClient>();

    public TestHttpClient() {
        super(TestHttpClient.preventSocketTimeoutException(null));
        instances.add(this);
    }

    public TestHttpClient(HttpParams params) {
        super(TestHttpClient.preventSocketTimeoutException(params));
        instances.add(this);
    }

    public TestHttpClient(ClientConnectionManager conman) {
        super(conman, TestHttpClient.preventSocketTimeoutException(null));
        instances.add(this);
    }

    public TestHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, TestHttpClient.preventSocketTimeoutException(params));
        instances.add(this);
    }

    private static HttpParams preventSocketTimeoutException(HttpParams params) {
        if (DefaultServer.isProxy()) {
            if (params == null) {
                params = new SyncBasicHttpParams();
                TestHttpClient.setDefaultHttpParams((HttpParams)params);
            }
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
            return params;
        }
        return params;
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler(0, false);
    }

    protected HttpParams createHttpParams() {
        HttpParams params = super.createHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
        return params;
    }

    public void setSSLContext(SSLContext sslContext) {
        SchemeRegistry registry = this.getConnectionManager().getSchemeRegistry();
        registry.unregister("https");
        if (DefaultServer.getHostAddress("default").equals("localhost")) {
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext)));
            registry.register(new Scheme("https", DefaultServer.getHostSSLPort("default"), (SchemeSocketFactory)new SSLSocketFactory(sslContext)));
        } else {
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext, NO_OP_VERIFIER)));
            registry.register(new Scheme("https", DefaultServer.getHostSSLPort("default"), (SchemeSocketFactory)new SSLSocketFactory(sslContext, NO_OP_VERIFIER)));
        }
    }

    public static void afterTest() {
        for (TestHttpClient i : instances) {
            i.getConnectionManager().shutdown();
        }
        instances.clear();
    }
}

