/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SetAttributeTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingHeader() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)Handlers.setAttribute((HttpHandler)ResponseCodeHandler.HANDLE_200, (String)"%{o,Foo}", (String)"%U-%{q,p1}", (ClassLoader)SetAttributeHandler.class.getClassLoader()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/a");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/path/a-", (Object)result.getHeaders("foo")[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/a?p1=someQp");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/path/a-someQp", (Object)result.getHeaders("foo")[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/a?p1=someQp&p1=value2");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"/path/a-[someQp, value2]", (Object)result.getHeaders("foo")[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewrite() throws IOException {
        DefaultServer.setRootHandler(Handlers.rewrite((String)"regex['/somePath/(.*)']", (String)"/otherPath/$1", (ClassLoader)this.getClass().getClassLoader(), (HttpHandler)Handlers.path().addPrefixPath("/otherPath", (HttpHandler)new InfoHandler()).addPrefixPath("/relative", Handlers.rewrite((String)"path-template['/foo/{bar}/{woz}']", (String)"/foo?bar=${bar}&woz=${woz}", (ClassLoader)this.getClass().getClassLoader(), (HttpHandler)new InfoHandler()))));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/relative/foo/a/b");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"URI: /relative/foo relative: /foo QS:bar=a&woz=b bar: a woz: b", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somePath/foo/a/b");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"URI: /otherPath/foo/a/b relative: /foo/a/b QS:", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somePath/foo?a=b");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"URI: /otherPath/foo relative: /foo QS:a=b a: b", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private class InfoHandler
    implements HttpHandler {
        private InfoHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            StringBuilder sb = new StringBuilder("URI: " + exchange.getRequestURI() + " relative: " + exchange.getRelativePath() + " QS:" + exchange.getQueryString());
            for (Map.Entry param : exchange.getQueryParameters().entrySet()) {
                sb.append(" " + (String)param.getKey() + ": " + (String)((Deque)param.getValue()).getFirst());
            }
            exchange.getResponseSender().send(sb.toString());
        }
    }
}

