/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIsServed() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadRequest() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path file = Paths.get(this.getClass().getResource("page.html").toURI());
        Path rootPath = file.getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 0xA00000L)).setDirectoryListingEnabled(true))));
            HttpHead get = new HttpHead(DefaultServer.getDefaultServerURL() + "/path/page.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)Long.toString(Files.size(file)), (Object)result.getHeaders("Content-Length")[0].getValue());
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListing() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)).setDirectoryListingEnabled(true))));
            try (CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path/"));){
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertNotNull((Object)result.getFirstHeader("Content-Type"));
                MatcherAssert.assertThat((Object)result.getFirstHeader("Content-Type").getValue(), (Matcher)CoreMatchers.startsWith((String)"text/html"));
                MatcherAssert.assertThat((Object)HttpClientUtils.readResponse((HttpResponse)result), (Matcher)CoreMatchers.containsString((String)"page.html"));
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path/?js"));
            try {
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertNotNull((Object)result.getFirstHeader("Content-Type"));
                MatcherAssert.assertThat((Object)result.getFirstHeader("Content-Type").getValue(), (Matcher)CoreMatchers.startsWith((String)"application/javascript"));
                MatcherAssert.assertThat((Object)HttpClientUtils.readResponse((HttpResponse)result), (Matcher)CoreMatchers.containsString((String)"growit()"));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path/?css"));
            try {
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertNotNull((Object)result.getFirstHeader("Content-Type"));
                MatcherAssert.assertThat((Object)result.getFirstHeader("Content-Type").getValue(), (Matcher)CoreMatchers.startsWith((String)"text/css"));
                MatcherAssert.assertThat((Object)HttpClientUtils.readResponse((HttpResponse)result), (Matcher)CoreMatchers.containsString((String)"data:image/png;base64"));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDirectoryListing() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)))));
            try (CloseableHttpResponse result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path"));){
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path?js"));
            try {
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + "/path?css"));
            try {
                Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDotSuffix() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html.");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTransfer() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileTransferLargeFile() throws IOException {
        TestHttpClient client = new TestHttpClient();
        Path tmp = Paths.get("target", "testtmp").toAbsolutePath();
        Files.createDirectories(tmp, new FileAttribute[0]);
        String message = "Hello World".repeat(100000);
        Path large = Files.createTempFile(tmp, null, ".txt", new FileAttribute[0]);
        try {
            Files.write(large, message.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(tmp, 1L)).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/" + large.getFileName().toString());
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((String)String.format("Failed to get file '%s' with request '%s'", large.toAbsolutePath(), get), (long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/plain", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.equals(message));
        }
        finally {
            client.getConnectionManager().shutdown();
            try {
                Files.delete(large);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeRequests() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)).setDirectoryListingEnabled(true))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            get.addHeader("range", "bytes=2-3");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertEquals((Object)"--", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            get.addHeader("range", "bytes=-7");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertEquals((Object)"</html>", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        Path rootPath = Paths.get(FileHandlerTestCase.class.getResource("page.html").toURI()).getParent().getParent();
        CanonicalPathHandler root = new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(rootPath, 1L)).setDirectoryListingEnabled(true)));
        Undertow undertow = Undertow.builder().addHttpListener(8888, "localhost").setHandler((HttpHandler)root).build();
        undertow.start();
    }
}

