/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.testutils.category.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnitTest.class})
public class HpackHuffmanDecodingStringLiteralRepresentation {
    @Test
    public void testStringLiteralContainingEOS() throws HpackException {
        byte[] data = new byte[]{0, -123, -14, -78, 74, -124, -1, -121, 73, 81, -1, -1, -1, -6, 127};
        HpackDecoder decoder = new HpackDecoder(256);
        Assert.assertThrows(HpackException.class, () -> decoder.decode(ByteBuffer.wrap(data), false));
    }

    @Test
    public void testStringLiteralPaddingLongerThan7Bits() throws HpackException {
        byte[] data = new byte[]{0, -123, -14, -78, 74, -124, -1, -124, 73, 80, -97, -1};
        HpackDecoder decoder = new HpackDecoder(256);
        Assert.assertThrows(HpackException.class, () -> decoder.decode(ByteBuffer.wrap(data), false));
    }

    @Test
    public void testStringLiteralPaddedByZero() throws HpackException {
        byte[] data = new byte[]{0, -123, -14, -78, 74, -124, -1, -125, 73, 80, -112};
        HpackDecoder decoder = new HpackDecoder(256);
        Assert.assertThrows(HpackException.class, () -> decoder.decode(ByteBuffer.wrap(data), false));
    }
}

