/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class HttpServerExchangeTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getHostName() + ":" + exchange.getProtocol() + ":" + exchange.getRequestMethod() + ":" + exchange.getHostPort() + ":" + exchange.getRequestURI() + ":" + exchange.getRelativePath() + ":" + exchange.getQueryString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpServerExchange() throws IOException {
        String port = DefaultServer.isAjp() && !DefaultServer.isProxy() ? "9080" : "7777";
        String protocol = DefaultServer.isH2() ? "HTTP/2.0" : "HTTP/1.1";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somepath");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + protocol + ":GET:" + port + ":/somepath:/somepath:"), (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somepath?a=b");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)(DefaultServer.getHostAddress() + ":" + protocol + ":GET:" + port + ":/somepath:/somepath:a=b"), (Object)HttpClientUtils.readResponse((HttpResponse)result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somepath?a=b");
            get.addHeader("Host", "[::1]:8080");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)("::1:" + protocol + ":GET:8080:/somepath:/somepath:a=b"), (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

