/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class ReadTimeoutTestCase {
    private static final Logger LOG = Logger.getLogger(ReadTimeoutTestCase.class);
    private static final int FORM_PARAM_LENGTH = 16384;
    private volatile Exception exception;

    @DefaultServer.BeforeServerStarts
    public static void beforeClass() {
        DefaultServer.setServerOptions(OptionMap.create((Option)Options.READ_TIMEOUT, (Object)10));
    }

    @DefaultServer.AfterServerStops
    public static void afterClass() {
        DefaultServer.setServerOptions(OptionMap.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeout() throws InterruptedException, IOException {
        CountDownLatch errorLatch = new CountDownLatch(1);
        DefaultServer.setRootHandler(exchange -> {
            StreamSinkChannel response = exchange.getResponseChannel();
            StreamSourceChannel request = exchange.getRequestChannel();
            request.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, channel -> new StringWriteChannelListener("COMPLETED"){

                protected void writeDone(StreamSinkChannel channel) {
                    exchange.endExchange();
                }
            }.setup(response), (channel, e) -> {
                e.printStackTrace();
                exchange.endExchange();
                this.exception = e;
                errorLatch.countDown();
            }));
            request.wakeupReads();
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new AbstractHttpEntity(){

                public InputStream getContent() throws IllegalStateException {
                    return null;
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    for (int i = 0; i < 5; ++i) {
                        outstream.write(42);
                        outstream.flush();
                        try {
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return 5L;
                }
            });
            post.addHeader("Connection", "close");
            boolean socketFailure = false;
            try {
                client.execute((HttpUriRequest)post);
            }
            catch (SocketException e) {
                Assert.assertTrue((String)e.getMessage(), (e.getMessage().contains("Broken pipe") || e.getMessage().contains("connection abort") || e.getMessage().contains("connection was aborted") ? 1 : 0) != 0);
                socketFailure = true;
            }
            Assert.assertTrue((String)"Test sent request without any exception", (boolean)socketFailure);
            if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                Assert.assertTrue((String)this.getExceptionDescription(this.exception), (this.exception instanceof ReadTimeoutException || DefaultServer.isProxy() && this.exception instanceof IOException ? 1 : 0) != 0);
                if (this.exception.getSuppressed() != null && this.exception.getSuppressed().length > 0) {
                    for (Throwable supressed : this.exception.getSuppressed()) {
                        Assert.assertEquals((String)this.getExceptionDescription(supressed), ReadTimeoutException.class, this.exception.getClass());
                    }
                }
            } else if (!DefaultServer.isProxy()) {
                Assert.fail((String)"Did not get ReadTimeoutException");
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testReadTimeoutWithSlowResponder() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)new BlockingHandler(exchange -> {
            FormParserFactory parserFactory = new FormParserFactory.Builder().addParser((FormParserFactory.ParserDefinition)new FormEncodedDataDefinition()).build();
            try (FormDataParser formDataParser = parserFactory.createParser(exchange);){
                FormData formData = formDataParser.parseBlocking();
                FormData.FormValue test = formData.getFirst("test");
                Assert.assertNotNull((Object)test);
                Assert.assertEquals((long)16384L, (long)test.getValue().length());
            }
            Sender responseSender = exchange.getResponseSender();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(200L);
                responseSender.send("*", new IoCallback(){

                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        LOG.debug((Object)"Sent '*'");
                    }

                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        LOG.warn((Object)"Failed to write data to response channel.", (Throwable)exception);
                    }
                });
            }
        }));
        try (TestHttpClient client = new TestHttpClient();){
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            StringBuilder sb = new StringBuilder(16384);
            for (int i = 0; i < 16384; ++i) {
                sb.append('a');
            }
            nameValuePairs.add(new BasicNameValuePair("test", sb.toString()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            client.execute((HttpUriRequest)post);
        }
        catch (NoHttpResponseException e) {
            Assert.fail((String)"No response was received, this was presumably caused by read-timeout closing the connection.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getExceptionDescription(Throwable exception) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                exception.printStackTrace(pw);
                String string = pw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

