/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

@RunWith(value=DefaultServer.class)
public class ResumeWritesTestCase {
    public static final String HELLO_WORLD = "Hello World";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResumeWritesFixedLength() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.addResponseWrapper((ConduitWrapper)new ReturnZeroWrapper());
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, (long)ResumeWritesTestCase.HELLO_WORLD.length());
                exchange.getResponseSender().send(ResumeWritesTestCase.HELLO_WORLD);
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResumeWritesChunked() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.addResponseWrapper((ConduitWrapper)new ReturnZeroWrapper());
                exchange.getResponseSender().send(ResumeWritesTestCase.HELLO_WORLD);
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResumeWritesHttp10() throws IOException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.addResponseWrapper((ConduitWrapper)new ReturnZeroWrapper());
                exchange.getResponseSender().send(ResumeWritesTestCase.HELLO_WORLD);
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)HELLO_WORLD, (Object)HttpClientUtils.readResponse((HttpResponse)result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static class ReturnZeroWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        private ReturnZeroWrapper() {
        }

        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            return new AbstractStreamSinkConduit<StreamSinkConduit>((StreamSinkConduit)factory.create()){
                int c;
                {
                    super(next);
                    this.c = 0;
                }

                public long transferFrom(FileChannel src, long position, long count) throws IOException {
                    if (this.c++ % 100 != 90) {
                        return 0L;
                    }
                    return super.transferFrom(src, position, count);
                }

                public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
                    if (this.c++ % 100 != 90) {
                        return 0L;
                    }
                    return super.transferFrom(source, count, throughBuffer);
                }

                public int write(ByteBuffer src) throws IOException {
                    if (this.c++ % 100 != 90) {
                        return 0;
                    }
                    return super.write(src);
                }

                public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
                    if (this.c++ % 100 != 90) {
                        return 0L;
                    }
                    return super.write(srcs, offs, len);
                }

                public boolean flush() throws IOException {
                    if (this.c++ % 100 != 90) {
                        return false;
                    }
                    return super.flush();
                }
            };
        }
    }
}

